/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.java;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.util.Digest;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class StableMethodNameFormatter
implements Function<ResolvedJavaMethod, String> {
    public static final String MULTI_METHOD_KEY_SEPARATOR = "%%";
    private static final Pattern LAMBDA_METHOD_PATTERN = Pattern.compile("\\$\\$Lambda\\$\\d+/0x[0-9a-f]+");
    private static final Pattern MH_METHOD_PATTERN = Pattern.compile("LambdaForm\\$[A-Z]*MH.0x[0-9a-f]+");
    private static final String LAMBDA_PREFIX = "$$Lambda$";
    private static final String MH_PREFIX = "LambdaForm$";
    public static final String METHOD_FORMAT = "%H.%n(%p)";
    private static final String INVOKED_METHOD_FORMAT = "%H.%n(%P)%R";
    private final boolean considerMH;
    private final EconomicMap<ResolvedJavaMethod, String> methodName = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

    public StableMethodNameFormatter(boolean considerMH) {
        this.considerMH = considerMH;
    }

    @Override
    public String apply(ResolvedJavaMethod method) {
        String result = (String)this.methodName.get((Object)method);
        if (result != null) {
            return result;
        }
        result = this.findMethodName(method);
        this.methodName.put((Object)method, (Object)result);
        return result;
    }

    private String findMethodName(ResolvedJavaMethod method) {
        if (LambdaUtils.isLambdaType(method.getDeclaringClass())) {
            return StableMethodNameFormatter.findStableLambdaMethodName(method);
        }
        if (this.considerMH && StableMethodNameFormatter.isMethodHandle(method.getDeclaringClass())) {
            return StableMethodNameFormatter.findStableMHName(method);
        }
        return method.format(METHOD_FORMAT);
    }

    public static boolean isMethodHandle(ResolvedJavaType declaringClass) {
        String typeName = declaringClass.getName();
        if (typeName.contains(MH_PREFIX)) {
            return MH_METHOD_PATTERN.matcher(typeName).find();
        }
        return false;
    }

    private static String findStableMHName(ResolvedJavaMethod method) {
        String lambdaName = method.format(METHOD_FORMAT);
        Matcher matcher = MH_METHOD_PATTERN.matcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        LambdaUtils.findInvokedMethods(method).forEach(targetMethod -> sb.append(targetMethod.format(INVOKED_METHOD_FORMAT)));
        return matcher.replaceFirst(Matcher.quoteReplacement(MH_PREFIX + Digest.digest(sb.toString())));
    }

    private static String findStableLambdaMethodName(ResolvedJavaMethod method) {
        String lambdaName = method.format(METHOD_FORMAT);
        Matcher matcher = LAMBDA_METHOD_PATTERN.matcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        LambdaUtils.findInvokedMethods(method).forEach(targetMethod -> sb.append(targetMethod.format(INVOKED_METHOD_FORMAT)));
        return matcher.replaceFirst(Matcher.quoteReplacement(LAMBDA_PREFIX + Digest.digest(sb.toString())));
    }
}

