/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.bytecode.BytecodeStream;
import jdk.graal.compiler.util.Digest;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class LambdaUtils {
    private static final Pattern LAMBDA_PATTERN = Pattern.compile("\\$\\$Lambda[/.][^/]+;");
    public static final String LAMBDA_SPLIT_PATTERN = "\\$\\$Lambda";
    public static final String LAMBDA_CLASS_NAME_SUBSTRING = "$$Lambda";
    public static final String SERIALIZATION_TEST_LAMBDA_CLASS_SUBSTRING = "$$Lambda";
    public static final String SERIALIZATION_TEST_LAMBDA_CLASS_SPLIT_PATTERN = "\\$\\$Lambda";
    public static final String ADDRESS_PREFIX = ".0x";

    private LambdaUtils() {
    }

    public static String findStableLambdaName(ResolvedJavaType lambdaType) {
        ResolvedJavaMethod[] lambdaProxyMethods = (ResolvedJavaMethod[])Arrays.stream(lambdaType.getDeclaredMethods(false)).filter(m -> !m.isBridge() && m.isPublic()).toArray(ResolvedJavaMethod[]::new);
        List<JavaMethod> invokedMethods = LambdaUtils.findInvokedMethods(lambdaProxyMethods[0]);
        if (invokedMethods.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Lambda without a target invoke: ").append(lambdaType.toClassName());
            for (ResolvedJavaMethod m2 : lambdaType.getDeclaredMethods(false)) {
                sb.append("\n  Method: ").append(m2);
            }
            throw new JVMCIError(sb.toString());
        }
        return LambdaUtils.createStableLambdaName(lambdaType, invokedMethods);
    }

    public static List<JavaMethod> findInvokedMethods(ResolvedJavaMethod method) {
        ConstantPool constantPool = method.getConstantPool();
        ArrayList<JavaMethod> invokedMethods = new ArrayList<JavaMethod>();
        BytecodeStream stream = new BytecodeStream(method.getCode());
        while (stream.currentBCI() < stream.endBCI()) {
            int opcode = stream.currentBC();
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    int cpi = stream.readCPI();
                    invokedMethods.add(constantPool.lookupMethod(cpi, opcode, method));
                    break;
                }
                case 186: {
                    int cpi = stream.readCPI4();
                    invokedMethods.add(constantPool.lookupMethod(cpi, opcode, method));
                    break;
                }
            }
            stream.next();
        }
        return invokedMethods;
    }

    public static boolean isLambdaType(ResolvedJavaType type) {
        String typeName = type.getName();
        return type.isFinalFlagSet() && LambdaUtils.isLambdaName(typeName);
    }

    public static boolean isLambdaName(String name) {
        return LambdaUtils.isLambdaClassName(name) && LambdaUtils.lambdaMatcher(name).find();
    }

    private static String createStableLambdaName(ResolvedJavaType lambdaType, List<JavaMethod> targetMethods) {
        String lambdaName = lambdaType.getName();
        assert (LambdaUtils.lambdaMatcher(lambdaName).find()) : "Stable name should be created for lambda types: " + lambdaName;
        Matcher m = LambdaUtils.lambdaMatcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        targetMethods.forEach(targetMethod -> sb.append(targetMethod.format("%H.%n(%P)%R")));
        for (ResolvedJavaMethod ctor : lambdaType.getDeclaredConstructors()) {
            sb.append(ctor.format("%P"));
        }
        return m.replaceFirst(Matcher.quoteReplacement("$$Lambda.0x" + Digest.digestAsHex(sb.toString()) + ";"));
    }

    private static Matcher lambdaMatcher(String value) {
        return LAMBDA_PATTERN.matcher(value);
    }

    public static String capturingClass(String className) {
        return className.split("\\$\\$Lambda")[0];
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return LambdaUtils.isLambdaClassName(clazz.getName());
    }

    public static boolean isLambdaClassName(String className) {
        return className.contains("$$Lambda");
    }
}

