/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.word;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class PointerCastNode
extends FloatingNode
implements Canonicalizable,
LIRLowerable,
Node.ValueNumberable {
    public static final NodeClass<PointerCastNode> TYPE = NodeClass.create(PointerCastNode.class);
    @Node.Input
    ValueNode input;

    protected PointerCastNode(Stamp stamp, ValueNode input) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        this.input = input;
    }

    public static ValueNode create(Stamp stamp, ValueNode input) {
        ValueNode canonicalNode = PointerCastNode.canonicalize(stamp, input);
        if (canonicalNode != null) {
            return canonicalNode;
        }
        return new PointerCastNode(stamp, input);
    }

    public ValueNode getInput() {
        return this.input;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        Value value = generator.operand(this.input);
        assert (value.getValueKind().equals((Object)generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT)))) : "PointerCastNode shouldn't change the LIRKind";
        generator.setResult(this, value);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode canonicalNode = PointerCastNode.canonicalize(this.stamp, this.input);
        if (canonicalNode != null) {
            return canonicalNode;
        }
        return this;
    }

    private static ValueNode canonicalize(Stamp stamp, ValueNode input) {
        if (input instanceof PointerCastNode) {
            PointerCastNode pointerCast = (PointerCastNode)input;
            if (pointerCast.input.stamp(NodeView.DEFAULT).equals(stamp)) {
                return pointerCast.input;
            }
        }
        return null;
    }
}

