/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.word;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodCountersPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodPointerStamp;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.hotspot.word.MetaspacePointer;
import jdk.graal.compiler.hotspot.word.MethodCountersPointer;
import jdk.graal.compiler.hotspot.word.MethodPointer;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HotSpotWordTypes
extends WordTypes {
    private final ResolvedJavaType metaspacePointerType;
    private final Class<?> metaspacePointerClass;
    private final ResolvedJavaType klassPointerType;
    private final ResolvedJavaType methodPointerType;
    private final ResolvedJavaType methodCountersPointerType;
    private final Class<?> klassPointerClass;
    private final Class<?> methodPointerClass;
    private final Class<?> methodCountersPointerClass;

    public HotSpotWordTypes(MetaAccessProvider metaAccess, JavaKind wordKind) {
        super(metaAccess, wordKind);
        this.metaspacePointerType = metaAccess.lookupJavaType(MetaspacePointer.class);
        this.metaspacePointerClass = MetaspacePointer.class;
        this.klassPointerType = metaAccess.lookupJavaType(KlassPointer.class);
        this.klassPointerClass = KlassPointer.class;
        this.methodPointerClass = MethodPointer.class;
        this.methodPointerType = metaAccess.lookupJavaType(MethodPointer.class);
        this.methodCountersPointerType = metaAccess.lookupJavaType(MethodCountersPointer.class);
        this.methodCountersPointerClass = MethodCountersPointer.class;
        assert (this.metaspacePointerType.isAssignableFrom(this.klassPointerType));
        assert (this.metaspacePointerType.isAssignableFrom(this.methodPointerType));
        assert (this.metaspacePointerType.isAssignableFrom(this.methodCountersPointerType));
    }

    @Override
    public boolean isWord(JavaType type) {
        if (type instanceof ResolvedJavaType && this.metaspacePointerType.isAssignableFrom((ResolvedJavaType)type)) {
            return true;
        }
        return super.isWord(type);
    }

    @Override
    public boolean isWord(Class<?> clazz) {
        if (this.metaspacePointerClass.isAssignableFrom(clazz)) {
            return true;
        }
        return super.isWord(clazz);
    }

    @Override
    public JavaKind asKind(JavaType type) {
        if (type instanceof ResolvedJavaType && this.metaspacePointerType.isAssignableFrom((ResolvedJavaType)type)) {
            return this.getWordKind();
        }
        return super.asKind(type);
    }

    @Override
    public Stamp getWordStamp(ResolvedJavaType type) {
        if (type.equals((Object)this.klassPointerType)) {
            return KlassPointerStamp.klass();
        }
        if (type.equals((Object)this.methodPointerType)) {
            return MethodPointerStamp.method();
        }
        if (type.equals((Object)this.methodCountersPointerType)) {
            return MethodCountersPointerStamp.methodCounters();
        }
        return super.getWordStamp(type);
    }

    @Override
    public Stamp getWordStamp(Class<?> type) {
        if (type.equals(this.klassPointerClass)) {
            return KlassPointerStamp.klass();
        }
        if (type.equals(this.methodPointerClass)) {
            return MethodPointerStamp.method();
        }
        if (type.equals(this.methodCountersPointerClass)) {
            return MethodCountersPointerStamp.methodCounters();
        }
        return super.getWordStamp(type);
    }
}

