/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.JumpToExceptionHandlerInCallerNode;
import jdk.graal.compiler.hotspot.nodes.StubForeignCallNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.stubs.ExceptionHandlerStub;
import jdk.graal.compiler.hotspot.stubs.SnippetStub;
import jdk.graal.compiler.hotspot.stubs.StubOptions;
import jdk.graal.compiler.hotspot.stubs.StubUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.Register;
import org.graalvm.word.LocationIdentity;

public class UnwindExceptionToCallerStub
extends SnippetStub {
    public static final HotSpotForeignCallDescriptor EXCEPTION_HANDLER_FOR_RETURN_ADDRESS = StubUtil.newDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any(), UnwindExceptionToCallerStub.class, "exceptionHandlerForReturnAddress", Word.class, Word.class, Word.class);

    public UnwindExceptionToCallerStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("unwindExceptionToCaller", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        if (index == 2) {
            return this.providers.getRegisters().getThreadRegister();
        }
        throw new InternalError();
    }

    @Snippet
    private static void unwindExceptionToCaller(Object exception, Word returnAddress, @Snippet.ConstantParameter Register threadRegister) {
        Word exceptionOop = Word.objectToTrackedPointer(exception);
        if (UnwindExceptionToCallerStub.logging(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            StubUtil.printf("unwinding exception %p (", exceptionOop.rawValue());
            StubUtil.decipher(exceptionOop.rawValue());
            StubUtil.printf(") at %p (", returnAddress.rawValue());
            StubUtil.decipher(returnAddress.rawValue());
            StubUtil.printf(")\n");
        }
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        ExceptionHandlerStub.checkNoExceptionInThread(thread, UnwindExceptionToCallerStub.assertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        ExceptionHandlerStub.checkExceptionNotNull(UnwindExceptionToCallerStub.assertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG), exception);
        Word handlerInCallerPc = UnwindExceptionToCallerStub.exceptionHandlerForReturnAddress(EXCEPTION_HANDLER_FOR_RETURN_ADDRESS, thread, returnAddress);
        if (UnwindExceptionToCallerStub.logging(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            StubUtil.printf("handler for exception %p at return address %p is at %p (", exceptionOop.rawValue(), returnAddress.rawValue(), handlerInCallerPc.rawValue());
            StubUtil.decipher(handlerInCallerPc.rawValue());
            StubUtil.printf(")\n");
        }
        JumpToExceptionHandlerInCallerNode.jumpToExceptionHandlerInCaller(handlerInCallerPc, exception, returnAddress);
    }

    @Fold
    static boolean logging(@Fold.InjectedParameter OptionValues options) {
        return StubOptions.TraceUnwindStub.getValue(options);
    }

    @Fold
    static boolean assertionsEnabled(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return Assertions.assertionsEnabled() || StubUtil.cAssertionsEnabled(config);
    }

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    public static native Word exceptionHandlerForReturnAddress(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2);
}

