/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import java.util.BitSet;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.SnippetParameterInfo;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.HighTierLoweringPhase;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class SnippetStub
extends Stub
implements Snippets {
    protected final ResolvedJavaMethod method;

    public SnippetStub(String snippetMethodName, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        this(null, snippetMethodName, options, providers, linkage);
    }

    public SnippetStub(Class<? extends Snippets> snippetDeclaringClass, String snippetMethodName, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(options, providers, linkage);
        this.method = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), snippetDeclaringClass == null ? this.getClass() : snippetDeclaringClass, snippetMethodName);
        this.registerSnippet();
    }

    protected void registerSnippet() {
        this.providers.getReplacements().registerSnippet(this.method, null, null, false, this.options);
    }

    @Override
    protected StructuredGraph getGraph(DebugContext debug, CompilationIdentifier compilationId) {
        SnippetParameterInfo info = this.providers.getReplacements().getSnippetParameterInfo(this.method);
        StructuredGraph graph = this.buildInitialGraph(debug, compilationId, this.makeConstArgs(info), SnippetParameterInfo.getNonNullParameters(info));
        try (DebugContext.Scope outer = debug.scope((Object)"SnippetStub", graph);){
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                int index = param.index();
                if (!info.isNonNullParameter(index)) continue;
                param.setStamp(param.stamp(NodeView.DEFAULT).join(StampFactory.objectNonNull()));
            }
            graph.getGraphState().initGuardsStage();
            CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
            canonicalizer.apply(graph, this.providers);
            new HighTierLoweringPhase(canonicalizer).apply(graph, this.providers);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return graph;
    }

    protected StructuredGraph buildInitialGraph(DebugContext debug, CompilationIdentifier compilationId, Object[] args, BitSet nonNullParameters) {
        return this.providers.getReplacements().getSnippet(this.method, null, args, nonNullParameters, false, null, this.options).copyWithIdentifier(compilationId, debug);
    }

    protected Object[] makeConstArgs(SnippetParameterInfo info) {
        Object[] args = new Object[info.getParameterCount()];
        for (int i = 0; i < args.length; ++i) {
            if (!info.isConstantParameter(i)) continue;
            args[i] = this.getConstantParameterValue(i, null);
        }
        return args;
    }

    protected Object getConstantParameterValue(int index, String name) {
        throw new GraalError("%s must override getConstantParameterValue() to provide a value for parameter %d%s", this.getClass().getName(), index, name == null ? "" : " (" + name + ")");
    }

    @Override
    protected Object debugScopeContext() {
        return this.getInstalledCodeOwner();
    }

    @Override
    public ResolvedJavaMethod getInstalledCodeOwner() {
        return this.method;
    }

    @Override
    public String toString() {
        return "Stub<" + this.getInstalledCodeOwner().format("%h.%n") + ">";
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }
}

