/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.DeoptimizeCallerNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.stubs.StubUtil;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class ForeignCallSnippets
implements Snippets {
    public static final LocationIdentity OBJECT_RESULT_LOCATION = NamedLocationIdentity.mutable("ObjectResult");

    @Snippet(allowMissingProbabilities=true)
    public static void handlePendingException(Word thread, boolean shouldClearException, boolean isObjectResult) {
        if (shouldClearException && HotSpotReplacementsUtil.clearPendingException(thread) != null || !shouldClearException && HotSpotReplacementsUtil.getPendingException(thread) != null) {
            if (isObjectResult) {
                ForeignCallSnippets.getAndClearObjectResult(thread);
            }
            DeoptimizeCallerNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
    }

    @Snippet(allowMissingProbabilities=true)
    public static Object verifyObject(Object object) {
        if (HotSpotReplacementsUtil.verifyOops(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            Word verifyOopCounter = (Word)WordFactory.unsigned((long)HotSpotReplacementsUtil.verifyOopCounterAddress(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
            verifyOopCounter.writeInt(0, verifyOopCounter.readInt(0) + 1);
            Word oop = Word.objectToTrackedPointer(object);
            if (object != null) {
                KlassPointer klass;
                GuardingNode anchorNode = SnippetAnchorNode.anchor();
                if (!oop.and(WordFactory.unsigned((long)HotSpotReplacementsUtil.verifyOopMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG))).equal(WordFactory.unsigned((long)HotSpotReplacementsUtil.verifyOopBits(GraalHotSpotVMConfig.INJECTED_VMCONFIG)))) {
                    StubUtil.fatal("oop not in heap: %p", oop.rawValue());
                }
                if ((klass = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode))).isNull()) {
                    StubUtil.fatal("klass for oop %p is null", oop.rawValue());
                }
            }
        }
        return object;
    }

    @Snippet
    public static Object getAndClearObjectResult(Word thread) {
        Object result = thread.readObject(ForeignCallSnippets.objectResultOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), OBJECT_RESULT_LOCATION);
        thread.writeObject(ForeignCallSnippets.objectResultOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), null, OBJECT_RESULT_LOCATION);
        return result;
    }

    @Fold
    static int objectResultOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.threadObjectResultOffset;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        final SnippetTemplate.SnippetInfo handlePendingException;
        final SnippetTemplate.SnippetInfo getAndClearObjectResult;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.handlePendingException = this.snippet((Providers)providers, ForeignCallSnippets.class, "handlePendingException", new LocationIdentity[0]);
            this.getAndClearObjectResult = this.snippet((Providers)providers, ForeignCallSnippets.class, "getAndClearObjectResult", OBJECT_RESULT_LOCATION);
        }
    }
}

