/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.JavaMethodContext;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import jdk.graal.compiler.hotspot.HotSpotReplacementsImpl;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotLoweringProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.ForeignCallSnippets;
import jdk.graal.compiler.hotspot.stubs.ForeignCallStub;
import jdk.graal.compiler.hotspot.stubs.HotSpotGraphKit;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.GraphKit;
import jdk.graal.compiler.replacements.nodes.ReadRegisterNode;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public abstract class AbstractForeignCallStub
extends Stub {
    protected final HotSpotJVMCIRuntime jvmciRuntime;
    protected final HotSpotForeignCallLinkage target;
    protected final boolean prependThread;

    public AbstractForeignCallStub(OptionValues options, HotSpotJVMCIRuntime runtime, HotSpotProviders providers, long address, HotSpotForeignCallDescriptor descriptor, HotSpotForeignCallLinkage.RegisterEffect effect, boolean prependThread) {
        super(options, providers, HotSpotForeignCallLinkageImpl.create(providers.getMetaAccess(), (CodeCacheProvider)providers.getCodeCache(), providers.getWordTypes(), providers.getForeignCalls(), descriptor, 0L, effect, effect == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS ? HotSpotForeignCallLinkageImpl.StackOnlyCallingConvention.StackOnlyCall : HotSpotCallingConventionType.JavaCall, effect == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS ? HotSpotForeignCallLinkageImpl.StackOnlyCallingConvention.StackOnlyCallee : HotSpotCallingConventionType.JavaCallee));
        this.jvmciRuntime = runtime;
        this.prependThread = prependThread;
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        HotSpotForeignCallDescriptor targetSig = this.getTargetSignature(descriptor);
        this.target = HotSpotForeignCallLinkageImpl.create(metaAccess, (CodeCacheProvider)providers.getCodeCache(), providers.getWordTypes(), providers.getForeignCalls(), targetSig, address, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall, null);
    }

    protected abstract HotSpotForeignCallDescriptor getTargetSignature(HotSpotForeignCallDescriptor var1);

    public final HotSpotForeignCallLinkage getTargetLinkage() {
        return this.target;
    }

    @Override
    protected final ResolvedJavaMethod getInstalledCodeOwner() {
        return null;
    }

    @Override
    protected final Object debugScopeContext() {
        return new DebugScopeContext(this){};
    }

    @Override
    protected final StructuredGraph getGraph(DebugContext debug, CompilationIdentifier compilationId) {
        boolean isObjectResult = this.returnsObject();
        boolean shouldClearException = this.shouldClearException();
        try {
            HotSpotLoweringProvider lowerer = (HotSpotLoweringProvider)this.providers.getLowerer();
            ForeignCallSnippets.Templates foreignCallSnippets = lowerer.getForeignCallSnippets();
            ResolvedJavaMethod handlePendingException = foreignCallSnippets.handlePendingException.getMethod();
            ResolvedJavaMethod getAndClearObjectResult = foreignCallSnippets.getAndClearObjectResult.getMethod();
            ResolvedJavaMethod thisMethod = this.getGraphMethod();
            HotSpotGraphKit kit = new HotSpotGraphKit(debug, thisMethod, this.providers, this.providers.getGraphBuilderPlugins(), compilationId, this.toString(), false, true);
            StructuredGraph graph = kit.getGraph();
            graph.getGraphState().forceDisableFrameStateVerification();
            ReadRegisterNode thread = kit.append(new ReadRegisterNode(this.providers.getRegisters().getThreadRegister(), this.providers.getWordTypes().getWordKind(), true, false));
            ValueNode result = this.createTargetCall(kit, thread);
            if (this.linkage.getDescriptor().getTransition() == HotSpotForeignCallDescriptor.Transition.SAFEPOINT) {
                kit.createIntrinsicInvoke(handlePendingException, thread, ConstantNode.forBoolean(shouldClearException, graph), ConstantNode.forBoolean(isObjectResult, graph));
            }
            if (isObjectResult) {
                result = kit.createIntrinsicInvoke(getAndClearObjectResult, thread);
            }
            kit.append(new ReturnNode(this.linkage.getDescriptor().getResultType() == Void.TYPE ? null : result));
            debug.dump(3, graph, "Initial stub graph");
            kit.inlineInvokesAsIntrinsics("Foreign call stub.", "Backend");
            debug.dump(3, graph, "Stub graph before compilation");
            return graph;
        }
        catch (Exception e) {
            throw GraalError.shouldNotReachHere(e);
        }
    }

    protected abstract boolean returnsObject();

    protected abstract boolean shouldClearException();

    private ResolvedJavaMethod getGraphMethod() {
        ResolvedJavaMethod thisMethod = null;
        MetaAccessProvider metaAccess = this.providers.getMetaAccess();
        for (ResolvedJavaMethod method : metaAccess.lookupJavaType(AbstractForeignCallStub.class).getDeclaredMethods(false)) {
            if (!method.getName().equals("getGraph")) continue;
            if (thisMethod == null) {
                thisMethod = method;
                continue;
            }
            throw new InternalError("getGraph is ambiguous");
        }
        if (thisMethod == null) {
            throw new InternalError("Can't find " + this.getClass().getSimpleName() + ".getGraph");
        }
        if (GraalServices.isBuildingLibgraal()) {
            HotSpotReplacementsImpl replacements = (HotSpotReplacementsImpl)this.providers.getReplacements();
            replacements.findSnippetMethod(thisMethod);
        }
        return thisMethod;
    }

    protected ParameterNode[] createParameters(GraphKit kit) {
        Class<?>[] args = this.linkage.getDescriptor().getArgumentTypes();
        ParameterNode[] params = new ParameterNode[args.length];
        MetaAccessProvider metaAccess = HotSpotReplacementsImpl.noticeTypes(this.providers.getMetaAccess());
        ResolvedJavaType accessingClass = metaAccess.lookupJavaType(this.getClass());
        for (int i = 0; i < args.length; ++i) {
            ParameterNode param;
            ResolvedJavaType type = metaAccess.lookupJavaType(args[i]).resolve(accessingClass);
            StampPair stamp = StampFactory.forDeclaredType(kit.getGraph().getAssumptions(), (JavaType)type, false);
            params[i] = param = kit.unique(new ParameterNode(i, stamp));
        }
        return params;
    }

    protected abstract ValueNode createTargetCall(GraphKit var1, ReadRegisterNode var2);

    private class DebugScopeContext
    implements JavaMethod,
    JavaMethodContext {
        private DebugScopeContext() {
        }

        @Override
        public JavaMethod asJavaMethod() {
            return this;
        }

        public Signature getSignature() {
            HotSpotForeignCallDescriptor d = AbstractForeignCallStub.this.linkage.getDescriptor();
            MetaAccessProvider metaAccess = AbstractForeignCallStub.this.providers.getMetaAccess();
            Class<?>[] arguments = d.getArgumentTypes();
            ResolvedJavaType[] parameters = new ResolvedJavaType[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                parameters[i] = metaAccess.lookupJavaType(arguments[i]);
            }
            return new HotSpotSignature(AbstractForeignCallStub.this.jvmciRuntime, metaAccess.lookupJavaType(d.getResultType()), parameters);
        }

        public String getName() {
            return AbstractForeignCallStub.this.linkage.getDescriptor().getName();
        }

        public JavaType getDeclaringClass() {
            return AbstractForeignCallStub.this.providers.getMetaAccess().lookupJavaType(ForeignCallStub.class);
        }

        public String toString() {
            return this.format("ForeignCallStub<%n(%p)>");
        }
    }
}

