/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.CurrentJavaThreadNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import jdk.graal.compiler.hotspot.replacements.UnsafeSetMemoryNode;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class UnsafeSnippets
implements Snippets {
    @Snippet
    static void copyMemory(Object receiver, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        Word srcAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(srcBase, srcOffset));
        Word dstAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(destBase, destOffset));
        Word size = (Word)WordFactory.signed((long)bytes);
        Word javaThread = CurrentJavaThreadNode.get();
        int offset = HotSpotReplacementsUtil.doingUnsafeAccessOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        LocationIdentity any = LocationIdentity.any();
        javaThread.writeByte(offset, (byte)1, any);
        HotSpotBackend.unsafeArraycopy(srcAddr, dstAddr, size);
        javaThread.writeByte(offset, (byte)0, any);
    }

    @Snippet
    static void setMemory(Object receiver, Object objBase, long objOffset, long bytes, byte value) {
        Word objAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(objBase, objOffset));
        Word size = (Word)WordFactory.signed((long)bytes);
        Word javaThread = CurrentJavaThreadNode.get();
        int offset = HotSpotReplacementsUtil.doingUnsafeAccessOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        LocationIdentity any = LocationIdentity.any();
        javaThread.writeByte(offset, (byte)1, any);
        HotSpotBackend.unsafeSetMemory(objAddr, size, value);
        javaThread.writeByte(offset, (byte)0, any);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo copyMemory;
        private final SnippetTemplate.SnippetInfo setMemory;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.copyMemory = this.snippet((Providers)providers, UnsafeSnippets.class, "copyMemory", new LocationIdentity[0]);
            this.setMemory = this.snippet((Providers)providers, UnsafeSnippets.class, "setMemory", new LocationIdentity[0]);
        }

        public void lower(UnsafeCopyMemoryNode copyMemoryNode, LoweringTool tool) {
            StructuredGraph graph = copyMemoryNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.copyMemory, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("receiver", copyMemoryNode.receiver);
            args.add("srcBase", copyMemoryNode.srcBase);
            args.add("srcOffset", copyMemoryNode.srcOffset);
            args.add("destBase", copyMemoryNode.destBase);
            args.add("destOffset", copyMemoryNode.desOffset);
            args.add("bytes", copyMemoryNode.bytes);
            SnippetTemplate template = this.template(tool, copyMemoryNode, args);
            template.instantiate(tool.getMetaAccess(), copyMemoryNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(UnsafeSetMemoryNode setMemoryNode, LoweringTool tool) {
            StructuredGraph graph = setMemoryNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.setMemory, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("receiver", setMemoryNode.receiver);
            args.add("objBase", setMemoryNode.obj);
            args.add("objOffset", setMemoryNode.offset);
            args.add("bytes", setMemoryNode.bytes);
            args.add("value", setMemoryNode.value);
            SnippetTemplate template = this.template(tool, setMemoryNode, args);
            template.instantiate(tool.getMetaAccess(), setMemoryNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

