/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_16, allowedUsageTypes={InputType.Memory})
public class UnsafeSetMemoryNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill,
MemoryAccess {
    public static final NodeClass<UnsafeSetMemoryNode> TYPE = NodeClass.create(UnsafeSetMemoryNode.class);
    @Node.Input
    ValueNode receiver;
    @Node.Input
    ValueNode obj;
    @Node.Input
    ValueNode offset;
    @Node.Input
    ValueNode bytes;
    @Node.Input
    ValueNode value;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;

    public UnsafeSetMemoryNode(ValueNode receiver, ValueNode obj, ValueNode offset, ValueNode bytes, ValueNode value) {
        super((NodeClass<? extends AbstractStateSplit>)TYPE, StampFactory.forVoid());
        this.receiver = receiver;
        this.obj = obj;
        this.offset = offset;
        this.bytes = bytes;
        this.value = value;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.getKilledLocationIdentity();
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }
}

