/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.CurrentJavaThreadNode;
import jdk.graal.compiler.hotspot.replacements.FastNotifyNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.word.LocationIdentity;

public class ObjectSnippets
implements Snippets {
    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native byte fastNotifyStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Object var2);

    static boolean fastNotifyStub(ForeignCallDescriptor descriptor, Object object) {
        return (ObjectSnippets.fastNotifyStub(descriptor, CurrentJavaThreadNode.get(), object) & 0xFF) != 0;
    }

    @Snippet
    public static void fastNotify(Object thisObj) {
        if (BranchProbabilityNode.probability(0.99, ObjectSnippets.fastNotifyStub(HotSpotHostForeignCallsProvider.NOTIFY, thisObj))) {
            return;
        }
        PiNode.piCastNonNull(thisObj, SnippetAnchorNode.anchor()).notify();
    }

    @Snippet
    public static void fastNotifyAll(Object thisObj) {
        if (BranchProbabilityNode.probability(0.99, ObjectSnippets.fastNotifyStub(HotSpotHostForeignCallsProvider.NOTIFY_ALL, thisObj))) {
            return;
        }
        PiNode.piCastNonNull(thisObj, SnippetAnchorNode.anchor()).notifyAll();
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo notifySnippet;
        private final SnippetTemplate.SnippetInfo notifyAllSnippet;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.notifySnippet = this.snippet((Providers)providers, ObjectSnippets.class, "fastNotify", Templates.findMethod(providers.getMetaAccess(), Object.class, "notify"), null, new LocationIdentity[0]);
            this.notifyAllSnippet = this.snippet((Providers)providers, ObjectSnippets.class, "fastNotifyAll", Templates.findMethod(providers.getMetaAccess(), Object.class, "notifyAll"), null, new LocationIdentity[0]);
        }

        public void lower(Node n, LoweringTool tool) {
            if (n instanceof FastNotifyNode) {
                FastNotifyNode fn = (FastNotifyNode)n;
                StructuredGraph graph = (StructuredGraph)n.graph();
                FrameState stateDuringCall = fn.stateDuring();
                assert (stateDuringCall != null) : "Must have valid state for snippet recursive notify call";
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(fn.isNotifyAll() ? this.notifyAllSnippet : this.notifySnippet, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("thisObj", fn.object);
                SnippetTemplate template = this.template(tool, fn, args);
                graph.getDebug().log("Lowering fast notify in %s: node=%s, template=%s, arguments=%s", graph, (Object)fn, (Object)template, (Object)args);
                UnmodifiableEconomicMap<Node, Node> duplicates = template.instantiate(tool.getMetaAccess(), fn, SnippetTemplate.DEFAULT_REPLACER, args);
                for (Node originalNode : duplicates.getKeys()) {
                    if (originalNode instanceof InvokeNode) {
                        InvokeNode invoke = (InvokeNode)duplicates.get((Object)originalNode);
                        assert (invoke.asNode().graph() == graph) : Assertions.errorMessage(invoke, invoke.asNode().graph(), graph);
                        invoke.setBci(fn.getBci());
                        invoke.setStateDuring(null);
                        invoke.setStateAfter(null);
                        invoke.setStateDuring(stateDuringCall);
                        continue;
                    }
                    if (!(originalNode instanceof InvokeWithExceptionNode)) continue;
                    throw new GraalError("unexpected invoke with exception %s in snippet", originalNode);
                }
            } else {
                GraalError.shouldNotReachHere("Unknown object snippet lowered node");
            }
        }
    }
}

