/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.meta.HotSpotLoweringProvider;
import jdk.graal.compiler.hotspot.replacements.ObjectCloneSnippets;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.nodes.BasicObjectCloneNode;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public final class ObjectCloneNode
extends BasicObjectCloneNode {
    public static final NodeClass<ObjectCloneNode> TYPE = NodeClass.create(ObjectCloneNode.class);

    public ObjectCloneNode(MacroNode.MacroParams p) {
        this(p, null);
    }

    private ObjectCloneNode(MacroNode.MacroParams p, FrameState stateAfter) {
        super(TYPE, p, stateAfter);
    }

    @Override
    protected ObjectCloneNode duplicateWithNewStamp(ObjectStamp newStamp) {
        return new ObjectCloneNode(this.copyParamsWithImprovedStamp(newStamp), this.stateAfter());
    }

    @Override
    public void lower(LoweringTool tool) {
        ResolvedJavaType concreteInputType = ObjectClone.getConcreteType(this.getObject().stamp(NodeView.DEFAULT));
        ResolvedJavaType cachedConcreteType = ObjectClone.getConcreteType(this.stamp(NodeView.DEFAULT));
        if (concreteInputType == null && cachedConcreteType != null || concreteInputType != null && !concreteInputType.equals((Object)cachedConcreteType)) {
            throw GraalError.shouldNotReachHere("object %s stamp %s concrete type %s; this %s stamp %s concrete type %s".formatted(this.getObject(), this.getObject().stamp(NodeView.DEFAULT), ObjectClone.getConcreteType(this.getObject().stamp(NodeView.DEFAULT)), this, this.stamp(NodeView.DEFAULT), ObjectClone.getConcreteType(this.stamp(NodeView.DEFAULT))));
        }
        StructuredGraph replacementGraph = this.getLoweredSnippetGraph(tool);
        if (replacementGraph != null) {
            ValueNode nonNullReceiver;
            InvokeNode invoke;
            try (InliningLog.UpdateScope updateScope = InliningLog.openUpdateScopeTrackingReplacement(this.graph().getInliningLog(), this);){
                invoke = this.createInvoke(true);
                this.graph().replaceFixedWithFixed(this, invoke);
            }
            if (!this.getTargetMethod().isStatic() && (nonNullReceiver = InliningUtil.nonNullReceiver(invoke)) instanceof Lowerable) {
                ((Lowerable)((Object)nonNullReceiver)).lower(tool);
            }
            InliningUtil.inline(invoke, replacementGraph, false, this.getTargetMethod(), "Replace with graph.", "LoweringPhase");
            replacementGraph.getDebug().dump(4, (Object)this.asNode().graph(), "After inlining replacement %s", replacementGraph);
        } else {
            super.lower(tool);
        }
    }

    private StructuredGraph getLoweredSnippetGraph(LoweringTool tool) {
        ResolvedJavaType type = StampTool.typeOrNull(this.getObject());
        if (type != null) {
            if (type.isArray()) {
                HotSpotLoweringProvider lowerer = (HotSpotLoweringProvider)tool.getLowerer();
                ObjectCloneSnippets.Templates objectCloneSnippets = lowerer.getObjectCloneSnippets();
                SnippetTemplate.SnippetInfo info = objectCloneSnippets.arrayCloneMethods.get(type.getComponentType().getJavaKind());
                if (info != null) {
                    ResolvedJavaMethod snippetMethod = info.getMethod();
                    Replacements replacements = tool.getReplacements();
                    StructuredGraph snippetGraph = null;
                    DebugContext debug = this.getDebug();
                    try (DebugContext.Scope s = debug.scope((Object)"ArrayCloneSnippet", snippetMethod);){
                        snippetGraph = replacements.getSnippet(snippetMethod, null, null, null, this.graph().trackNodeSourcePosition(), this.getNodeSourcePosition(), debug.getOptions());
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                    assert (snippetGraph != null) : "ObjectCloneSnippets should be installed";
                    assert (ObjectClone.getConcreteType(this.stamp(NodeView.DEFAULT)) != null);
                    return MacroInvokable.lowerReplacement(this.graph(), (StructuredGraph)snippetGraph.copy(this.getDebug()), tool);
                }
                GraalError.shouldNotReachHere("unhandled array type " + String.valueOf(type.getComponentType().getJavaKind()));
            } else {
                Assumptions assumptions = this.graph().getAssumptions();
                type = ObjectClone.getConcreteType(this.getObject().stamp(NodeView.DEFAULT));
                if (type != null) {
                    StructuredGraph newGraph = new StructuredGraph.Builder(this.graph().getOptions(), this.graph().getDebug(), StructuredGraph.AllowAssumptions.ifNonNull(assumptions)).name("<clone>").build();
                    ParameterNode param = newGraph.addWithoutUnique(new ParameterNode(0, StampPair.createSingle(this.getObject().stamp(NodeView.DEFAULT))));
                    CommitAllocationNode commit = newGraph.add(new CommitAllocationNode());
                    newGraph.addAfterFixed(newGraph.start(), commit);
                    VirtualObjectNode virtualObj = newGraph.add(new VirtualInstanceNode(type, true));
                    virtualObj.setObjectId(0);
                    AllocatedObjectNode newObj = newGraph.addWithoutUnique(new AllocatedObjectNode(virtualObj));
                    commit.getVirtualObjects().add(virtualObj);
                    newObj.setCommit(commit);
                    ReturnNode returnNode = newGraph.add(new ReturnNode(newObj));
                    newGraph.addAfterFixed(commit, returnNode);
                    List<ValueNode> commitValues = commit.getValues();
                    for (ResolvedJavaField field : type.getInstanceFields(true)) {
                        LoadFieldNode load = newGraph.add(LoadFieldNode.create(newGraph.getAssumptions(), param, field));
                        newGraph.addBeforeFixed(commit, load);
                        commitValues.add(load);
                    }
                    commit.addLocks(Collections.emptyList());
                    commit.getEnsureVirtual().add(false);
                    assert (commit.verify());
                    assert (ObjectClone.getConcreteType(this.stamp(NodeView.DEFAULT)) != null);
                    return MacroInvokable.lowerReplacement(this.graph(), newGraph, tool);
                }
            }
        }
        assert (ObjectClone.getConcreteType(this.stamp(NodeView.DEFAULT)) == null);
        return null;
    }
}

