/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public final class KlassLayoutHelperNode
extends FloatingNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<KlassLayoutHelperNode> TYPE = NodeClass.create(KlassLayoutHelperNode.class);
    @Node.Input
    protected ValueNode klass;
    private final int klassLayoutHelperNeutralValue;

    public KlassLayoutHelperNode(ValueNode klass, int klassLayoutHelperNeutralValue) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.klass = klass;
        this.klassLayoutHelperNeutralValue = klassLayoutHelperNeutralValue;
    }

    public static ValueNode create(GraalHotSpotVMConfig config, ValueNode klass, ConstantReflectionProvider constantReflection) {
        return KlassLayoutHelperNode.canonical(null, klass, constantReflection, config.klassLayoutHelperNeutralValue);
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter GraalHotSpotVMConfig config, ValueNode klass) {
        ValueNode valueNode = KlassLayoutHelperNode.create(config, klass, b.getConstantReflection());
        b.push(JavaKind.Int, b.append(valueNode));
        return true;
    }

    @Override
    public boolean inferStamp() {
        ObjectStamp objectStamp;
        ResolvedJavaType type;
        LoadHubNode hub;
        Stamp hubStamp;
        if (this.klass instanceof LoadHubNode && (hubStamp = (hub = (LoadHubNode)this.klass).getValue().stamp(NodeView.DEFAULT)) instanceof ObjectStamp && (type = (objectStamp = (ObjectStamp)hubStamp).type()) != null && !type.isJavaLangObject()) {
            if (!type.isArray() && !type.isInterface()) {
                return this.updateStamp(StampFactory.forInteger(JavaKind.Int, this.klassLayoutHelperNeutralValue, Integer.MAX_VALUE));
            }
            if (type.isArray()) {
                return this.updateStamp(StampFactory.forInteger(JavaKind.Int, Integer.MIN_VALUE, this.klassLayoutHelperNeutralValue - 1));
            }
        }
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        return KlassLayoutHelperNode.canonical(this, this.klass, tool.getConstantReflection(), this.klassLayoutHelperNeutralValue);
    }

    private static ValueNode canonical(KlassLayoutHelperNode klassLayoutHelperNode, ValueNode klass, ConstantReflectionProvider constantReflection, int klassLayoutHelperNeutralValue) {
        ObjectStamp ostamp;
        HotSpotResolvedObjectType type;
        LoadHubNode hub;
        Stamp hubStamp;
        KlassLayoutHelperNode self = klassLayoutHelperNode;
        if (klass.isConstant() && !klass.asConstant().isDefaultForKind()) {
            HotSpotResolvedObjectType javaType = (HotSpotResolvedObjectType)constantReflection.asJavaType(klass.asConstant());
            return ConstantNode.forInt(javaType.layoutHelper());
        }
        if (klass instanceof LoadHubNode && (hubStamp = (hub = (LoadHubNode)klass).getValue().stamp(NodeView.DEFAULT)) instanceof ObjectStamp && (type = (HotSpotResolvedObjectType)(ostamp = (ObjectStamp)hubStamp).type()) != null && type.isArray() && !type.getComponentType().isPrimitive()) {
            return ConstantNode.forInt(type.layoutHelper());
        }
        if (self == null) {
            self = new KlassLayoutHelperNode(klass, klassLayoutHelperNeutralValue);
        }
        return self;
    }

    public ValueNode getHub() {
        return this.klass;
    }
}

