/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.replacements.ClassGetHubNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.HotspotSnippetsOptions;
import jdk.graal.compiler.hotspot.replacements.TypeCheckSnippetUtils;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.TypeCheckHints;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.InstanceOfSnippetsTemplates;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.ExplodeLoopNode;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.TriState;
import org.graalvm.word.LocationIdentity;

public class InstanceOfSnippets
implements Snippets {
    @Snippet
    public static Object instanceofWithProfile(Object object, @Snippet.VarargsParameter KlassPointer[] hints, @Snippet.VarargsParameter boolean[] hintIsPositive, Object trueValue, Object falseValue, @Snippet.ConstantParameter boolean nullSeen, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            if (!nullSeen) {
                DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.OptimizedTypeCheckViolated);
            }
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < hints.length; ++i) {
            KlassPointer hintHub = hints[i];
            boolean positive = hintIsPositive[i];
            if (BranchProbabilityNode.probability(0.6, hintHub.equal(objectHub))) {
                counters.hintsHit.inc();
                return BranchProbabilityNode.unknownProbability(positive) ? trueValue : falseValue;
            }
            counters.hintsMiss.inc();
        }
        DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.OptimizedTypeCheckViolated);
        return falseValue;
    }

    @Snippet
    public static Object instanceofExact(Object object, KlassPointer exactHub, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubOrNullIntrinsic(object);
        if (BranchProbabilityNode.probability(0.6, objectHub.notEqual(exactHub))) {
            counters.exactMiss.inc();
            return falseValue;
        }
        counters.exactHit.inc();
        return trueValue;
    }

    @Snippet
    public static Object instanceofPrimary(KlassPointer hub, Object object, @Snippet.ConstantParameter int superCheckOffset, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        if (BranchProbabilityNode.probability(0.4, objectHub.readKlassPointer(superCheckOffset, HotSpotReplacementsUtil.PRIMARY_SUPERS_LOCATION).notEqual(hub))) {
            counters.displayMiss.inc();
            return falseValue;
        }
        counters.displayHit.inc();
        return trueValue;
    }

    @Snippet(allowMissingProbabilities=true)
    public static Object instanceofSecondary(KlassPointer hub, Object object, @Snippet.VarargsParameter KlassPointer[] hints, @Snippet.VarargsParameter boolean[] hintIsPositive, @Snippet.ConstantParameter boolean isHubAbstract, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < hints.length; ++i) {
            KlassPointer hintHub = hints[i];
            boolean positive = hintIsPositive[i];
            if (!BranchProbabilityNode.probability(0.09999999999999998, hintHub.equal(objectHub))) continue;
            counters.hintsHit.inc();
            return positive ? trueValue : falseValue;
        }
        counters.hintsMiss.inc();
        if (!TypeCheckSnippetUtils.checkSecondarySubType(hub, objectHub, isHubAbstract, counters)) {
            return falseValue;
        }
        return trueValue;
    }

    @Snippet(allowMissingProbabilities=true)
    public static Object instanceofDynamic(KlassPointer hub, Object object, Object trueValue, Object falseValue, @Snippet.ConstantParameter boolean allowNull, @Snippet.ConstantParameter boolean exact, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            if (allowNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer nonNullObjectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        if (exact) {
            if (BranchProbabilityNode.probability(0.6, nonNullObjectHub.notEqual(hub))) {
                counters.exactMiss.inc();
                return falseValue;
            }
            counters.exactHit.inc();
            return trueValue;
        }
        if (BranchProbabilityNode.probability(0.99, !hub.isNull()) && TypeCheckSnippetUtils.checkUnknownSubType(hub, nonNullObjectHub, counters)) {
            return trueValue;
        }
        return falseValue;
    }

    @Snippet(allowMissingProbabilities=true)
    public static Object isAssignableFrom(@Snippet.NonNullParameter Class<?> thisClassNonNull, @Snippet.NonNullParameter Class<?> otherClassNonNull, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        GuardingNode guardNonNull;
        KlassPointer nonNullOtherHub;
        if (BranchProbabilityNode.probability(0.4, thisClassNonNull == otherClassNonNull)) {
            return trueValue;
        }
        KlassPointer thisHub = ClassGetHubNode.readClass(thisClassNonNull);
        KlassPointer otherHub = ClassGetHubNode.readClass(otherClassNonNull);
        if (BranchProbabilityNode.probability(0.99, !thisHub.isNull()) && BranchProbabilityNode.probability(0.99, !otherHub.isNull()) && TypeCheckSnippetUtils.checkUnknownSubType(thisHub, nonNullOtherHub = ClassGetHubNode.piCastNonNull(otherHub, guardNonNull = SnippetAnchorNode.anchor()), counters)) {
            return trueValue;
        }
        return falseValue;
    }

    public static class Templates
    extends InstanceOfSnippetsTemplates {
        private final SnippetTemplate.SnippetInfo instanceofWithProfile;
        private final SnippetTemplate.SnippetInfo instanceofExact;
        private final SnippetTemplate.SnippetInfo instanceofPrimary;
        private final SnippetTemplate.SnippetInfo instanceofSecondary;
        private final SnippetTemplate.SnippetInfo instanceofDynamic;
        private final SnippetTemplate.SnippetInfo isAssignableFrom;
        private final TypeCheckSnippetUtils.Counters counters;

        public Templates(OptionValues options, SnippetCounter.Group.Factory factory, HotSpotProviders providers) {
            super(options, providers);
            this.instanceofWithProfile = this.snippet((Providers)providers, InstanceOfSnippets.class, "instanceofWithProfile", new LocationIdentity[0]);
            this.instanceofExact = this.snippet((Providers)providers, InstanceOfSnippets.class, "instanceofExact", new LocationIdentity[0]);
            this.instanceofPrimary = this.snippet((Providers)providers, InstanceOfSnippets.class, "instanceofPrimary", HotSpotReplacementsUtil.PRIMARY_SUPERS_LOCATION);
            this.instanceofSecondary = this.snippet((Providers)providers, InstanceOfSnippets.class, "instanceofSecondary", HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
            this.instanceofDynamic = this.snippet((Providers)providers, InstanceOfSnippets.class, "instanceofDynamic", HotSpotReplacementsUtil.OPTIMIZING_PRIMARY_SUPERS_LOCATION, HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
            this.isAssignableFrom = this.snippet((Providers)providers, InstanceOfSnippets.class, "isAssignableFrom", HotSpotReplacementsUtil.OPTIMIZING_PRIMARY_SUPERS_LOCATION, HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
            this.counters = new TypeCheckSnippetUtils.Counters(factory);
        }

        @Override
        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            if (replacer.instanceOf instanceof InstanceOfNode) {
                SnippetTemplate.Arguments args;
                InstanceOfNode instanceOf = (InstanceOfNode)replacer.instanceOf;
                ValueNode object = instanceOf.getValue();
                Assumptions assumptions = instanceOf.graph().getAssumptions();
                OptionValues localOptions = instanceOf.getOptions();
                JavaTypeProfile profile = instanceOf.profile();
                TypeCheckHints hintInfo = new TypeCheckHints(instanceOf.type(), profile, assumptions, HotspotSnippetsOptions.TypeCheckMinProfileHitProbability.getValue(localOptions), HotspotSnippetsOptions.TypeCheckMaxHints.getValue(localOptions));
                HotSpotResolvedObjectType type = (HotSpotResolvedObjectType)instanceOf.type().getType();
                ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), type.klass(), tool.getMetaAccess(), instanceOf.graph());
                StructuredGraph graph = instanceOf.graph();
                if (hintInfo.hintHitProbability >= 1.0 && hintInfo.exact == null) {
                    TypeCheckSnippetUtils.Hints hints = TypeCheckSnippetUtils.createHints(hintInfo, tool.getMetaAccess(), false, graph);
                    args = new SnippetTemplate.Arguments(this.instanceofWithProfile, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("object", object);
                    args.addVarargs("hints", KlassPointer.class, KlassPointerStamp.klassNonNull(), hints.hubs);
                    args.addVarargs("hintIsPositive", Boolean.TYPE, StampFactory.forKind(JavaKind.Boolean), hints.isPositive);
                } else if (hintInfo.exact != null) {
                    args = new SnippetTemplate.Arguments(this.instanceofExact, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("object", object);
                    args.add("exactHub", ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), ((HotSpotResolvedObjectType)hintInfo.exact).klass(), tool.getMetaAccess(), graph));
                } else if (type.isPrimaryType()) {
                    args = new SnippetTemplate.Arguments(this.instanceofPrimary, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", hub);
                    args.add("object", object);
                    args.add("superCheckOffset", type.superCheckOffset());
                } else {
                    TypeCheckSnippetUtils.Hints hints = TypeCheckSnippetUtils.createHints(hintInfo, tool.getMetaAccess(), false, graph);
                    args = new SnippetTemplate.Arguments(this.instanceofSecondary, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", hub);
                    args.add("object", object);
                    args.addVarargs("hints", KlassPointer.class, KlassPointerStamp.klassNonNull(), hints.hubs);
                    args.addVarargs("hintIsPositive", Boolean.TYPE, StampFactory.forKind(JavaKind.Boolean), hints.isPositive);
                    args.add("isHubAbstract", !type.isArray() && (type.isAbstract() || type.isInterface()));
                }
                args.add("trueValue", replacer.trueValue);
                args.add("falseValue", replacer.falseValue);
                if (hintInfo.hintHitProbability >= 1.0 && hintInfo.exact == null) {
                    args.add("nullSeen", hintInfo.profile.getNullSeen() != TriState.FALSE);
                }
                args.add("counters", this.counters);
                return args;
            }
            if (replacer.instanceOf instanceof InstanceOfDynamicNode) {
                InstanceOfDynamicNode instanceOf = (InstanceOfDynamicNode)replacer.instanceOf;
                ValueNode object = instanceOf.getObject();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.instanceofDynamic, instanceOf.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("hub", instanceOf.getMirrorOrHub());
                args.add("object", object);
                args.add("trueValue", replacer.trueValue);
                args.add("falseValue", replacer.falseValue);
                args.add("allowNull", instanceOf.allowsNull());
                args.add("exact", instanceOf.isExact());
                args.add("counters", this.counters);
                return args;
            }
            if (replacer.instanceOf instanceof ClassIsAssignableFromNode) {
                ClassIsAssignableFromNode isAssignable = (ClassIsAssignableFromNode)replacer.instanceOf;
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.isAssignableFrom, isAssignable.graph().getGuardsStage(), tool.getLoweringStage());
                assert (((ObjectStamp)isAssignable.getThisClass().stamp(NodeView.DEFAULT)).nonNull());
                assert (((ObjectStamp)isAssignable.getOtherClass().stamp(NodeView.DEFAULT)).nonNull());
                args.add("thisClassNonNull", isAssignable.getThisClass());
                args.add("otherClassNonNull", isAssignable.getOtherClass());
                args.add("trueValue", replacer.trueValue);
                args.add("falseValue", replacer.falseValue);
                args.add("counters", this.counters);
                return args;
            }
            throw GraalError.shouldNotReachHereUnexpectedValue(replacer);
        }
    }
}

