/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConvertNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.HubGetClassNodeInterface;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class HubGetClassNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
ConvertNode,
HubGetClassNodeInterface {
    public static final NodeClass<HubGetClassNode> TYPE = NodeClass.create(HubGetClassNode.class);
    @Node.Input
    protected ValueNode hub;

    public HubGetClassNode(@Node.InjectedNodeParameter MetaAccessProvider metaAccess, ValueNode hub) {
        super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createWithoutAssumptions(metaAccess.lookupJavaType(Class.class))));
        this.hub = hub;
    }

    @Override
    public ValueNode getHub() {
        return this.hub;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType exactType;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        MetaAccessProvider metaAccess = tool.getMetaAccess();
        if (metaAccess != null && this.hub.isConstant() && (exactType = tool.getConstantReflection().asJavaType(this.hub.asConstant())) != null) {
            return ConstantNode.forConstant(tool.getConstantReflection().asJavaClass(exactType), metaAccess);
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native Class<?> readClass(KlassPointer var0);

    @Override
    public ValueNode getValue() {
        return this.hub;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        if (JavaConstant.NULL_POINTER.equals((Object)c)) {
            return c;
        }
        return constantReflection.asJavaClass(constantReflection.asJavaType(c));
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        if (JavaConstant.NULL_POINTER.equals((Object)c)) {
            return c;
        }
        ResolvedJavaType type = constantReflection.asJavaType(c);
        if (type.isPrimitive()) {
            return JavaConstant.NULL_POINTER;
        }
        return constantReflection.asObjectHub(type);
    }

    @Override
    public boolean isLossless() {
        return true;
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return true;
    }
}

