/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.nodes.HotSpotCompressionNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.Log;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.G1ArrayRangePostWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1ArrayRangePreWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1PostWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1PreWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1ReferentFieldReadBarrierNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.gc.G1WriteBarrierSnippets;
import jdk.graal.compiler.replacements.gc.WriteBarrierSnippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class HotSpotG1WriteBarrierSnippets
extends G1WriteBarrierSnippets {
    public static final HotSpotForeignCallDescriptor G1WBPRECALL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, KILLED_PRE_WRITE_BARRIER_STUB_LOCATIONS, "write_barrier_pre", Void.TYPE, Object.class);
    public static final HotSpotForeignCallDescriptor G1WBPOSTCALL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, KILLED_POST_WRITE_BARRIER_STUB_LOCATIONS, "write_barrier_post", Void.TYPE, Word.class);
    public static final HotSpotForeignCallDescriptor VALIDATE_OBJECT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "validate_object", Boolean.TYPE, Word.class, Word.class);
    private final Register threadRegister;

    public HotSpotG1WriteBarrierSnippets(HotSpotRegistersProvider registers) {
        this.threadRegister = registers.getThreadRegister();
    }

    @Override
    protected Word getThread() {
        return HotSpotReplacementsUtil.registerAsWord(this.threadRegister);
    }

    @Override
    protected int wordSize() {
        return HotSpotReplacementsUtil.wordSize();
    }

    @Override
    protected long objectArrayIndexScale() {
        return ReplacementsUtil.arrayIndexScale(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Object);
    }

    @Override
    protected int satbQueueMarkingActiveOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueMarkingActiveOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int satbQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueBufferOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int satbQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1SATBQueueIndexOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int cardQueueBufferOffset() {
        return HotSpotReplacementsUtil.g1CardQueueBufferOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected int cardQueueIndexOffset() {
        return HotSpotReplacementsUtil.g1CardQueueIndexOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected byte dirtyCardValue() {
        return HotSpotReplacementsUtil.dirtyCardValue(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected byte youngCardValue() {
        return HotSpotReplacementsUtil.g1YoungCardValue(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected Word cardTableAddress(Pointer oop) {
        Word cardTable = (Word)WordFactory.unsigned((long)HotSpotReplacementsUtil.cardTableStart(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        int cardTableShift = HotSpotReplacementsUtil.cardTableShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        return cardTable.add(oop.unsignedShiftRight(cardTableShift));
    }

    @Override
    protected int logOfHeapRegionGrainBytes() {
        return HotSpotReplacementsUtil.logOfHeapRegionGrainBytes(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected ForeignCallDescriptor preWriteBarrierCallDescriptor() {
        return G1WBPRECALL;
    }

    @Override
    protected ForeignCallDescriptor postWriteBarrierCallDescriptor() {
        return G1WBPOSTCALL;
    }

    @Override
    protected boolean verifyOops() {
        return HotSpotReplacementsUtil.verifyOops(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected boolean verifyBarrier() {
        return ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED || HotSpotReplacementsUtil.verifyBeforeOrAfterGC(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected long gcTotalCollectionsAddress() {
        return HotSpotReplacementsUtil.gcTotalCollectionsAddress(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected ForeignCallDescriptor verifyOopCallDescriptor() {
        return HotSpotForeignCallsProviderImpl.VERIFY_OOP;
    }

    @Override
    protected ForeignCallDescriptor validateObjectCallDescriptor() {
        return VALIDATE_OBJECT;
    }

    @Override
    protected ForeignCallDescriptor printfCallDescriptor() {
        return Log.LOG_PRINTF;
    }

    static final class HotspotG1WriteBarrierLowerer
    extends G1WriteBarrierSnippets.G1WriteBarrierLowerer {
        private final CompressEncoding oopEncoding;

        HotspotG1WriteBarrierLowerer(GraalHotSpotVMConfig config, SnippetCounter.Group.Factory factory) {
            super(factory);
            this.oopEncoding = config.useCompressedOops ? config.getOopEncoding() : null;
        }

        @Override
        public ValueNode uncompress(ValueNode expected) {
            assert (this.oopEncoding != null);
            return HotSpotCompressionNode.uncompress(expected.graph(), expected, this.oopEncoding);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo g1PreWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ReferentReadBarrier;
        private final SnippetTemplate.SnippetInfo g1PostWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ArrayRangePreWriteBarrier;
        private final SnippetTemplate.SnippetInfo g1ArrayRangePostWriteBarrier;
        private final G1WriteBarrierSnippets.G1WriteBarrierLowerer lowerer;

        public Templates(OptionValues options, SnippetCounter.Group.Factory factory, HotSpotProviders providers, GraalHotSpotVMConfig config) {
            super(options, providers);
            this.lowerer = new HotspotG1WriteBarrierLowerer(config, factory);
            HotSpotG1WriteBarrierSnippets receiver = new HotSpotG1WriteBarrierSnippets(providers.getRegisters());
            this.g1PreWriteBarrier = this.snippet((Providers)providers, G1WriteBarrierSnippets.class, "g1PreWriteBarrier", null, (Object)receiver, G1WriteBarrierSnippets.SATB_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_ACTIVE_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1ReferentReadBarrier = this.snippet((Providers)providers, G1WriteBarrierSnippets.class, "g1ReferentReadBarrier", null, (Object)receiver, G1WriteBarrierSnippets.SATB_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_ACTIVE_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1PostWriteBarrier = this.snippet((Providers)providers, G1WriteBarrierSnippets.class, "g1PostWriteBarrier", null, (Object)receiver, WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION);
            this.g1ArrayRangePreWriteBarrier = this.snippet((Providers)providers, G1WriteBarrierSnippets.class, "g1ArrayRangePreWriteBarrier", null, (Object)receiver, G1WriteBarrierSnippets.SATB_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_ACTIVE_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION);
            this.g1ArrayRangePostWriteBarrier = this.snippet((Providers)providers, G1WriteBarrierSnippets.class, "g1ArrayRangePostWriteBarrier", null, (Object)receiver, WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION);
        }

        public void lower(G1PreWriteBarrierNode barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1PreWriteBarrier, barrier, tool);
        }

        public void lower(G1ReferentFieldReadBarrierNode barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ReferentReadBarrier, barrier, tool);
        }

        public void lower(G1PostWriteBarrierNode barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1PostWriteBarrier, barrier, tool);
        }

        public void lower(G1ArrayRangePreWriteBarrierNode barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ArrayRangePreWriteBarrier, barrier, tool);
        }

        public void lower(G1ArrayRangePostWriteBarrierNode barrier, LoweringTool tool) {
            this.lowerer.lower((SnippetTemplate.AbstractTemplates)this, this.g1ArrayRangePostWriteBarrier, barrier, tool);
        }
    }
}

