/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.FallbackInvokeWithExceptionNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class DigestBaseSnippets
implements Snippets {
    @Snippet(allowMissingProbabilities=true)
    static int implCompressMultiBlock0(Object receiver, byte[] buf, int ofs, int limit, @Snippet.ConstantParameter ResolvedJavaType receiverType, @Snippet.ConstantParameter ResolvedJavaType md5type, @Snippet.ConstantParameter ResolvedJavaType sha1type, @Snippet.ConstantParameter ResolvedJavaType sha256type, @Snippet.ConstantParameter ResolvedJavaType sha512type, @Snippet.ConstantParameter ResolvedJavaType sha3type) {
        Object realReceiver = PiNode.piCast(receiver, receiverType, false, true, SnippetAnchorNode.anchor());
        Word bufAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(buf, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + ofs));
        if (DigestBaseSnippets.useMD5Intrinsics(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && InstanceOfNode.doInstanceof(md5type, realReceiver)) {
            Object md5obj = PiNode.piCast(realReceiver, md5type, false, true, SnippetAnchorNode.anchor());
            Object state = RawLoadNode.load(md5obj, HotSpotReplacementsUtil.getFieldOffset(md5type, "state"), JavaKind.Object, LocationIdentity.any());
            Word stateAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(state, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int)));
            return HotSpotBackend.md5ImplCompressMBStub(bufAddr, stateAddr, ofs, limit);
        }
        if (DigestBaseSnippets.useSHA1Intrinsics(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && InstanceOfNode.doInstanceof(sha1type, realReceiver)) {
            Object sha1obj = PiNode.piCast(realReceiver, sha1type, false, true, SnippetAnchorNode.anchor());
            Object state = RawLoadNode.load(sha1obj, HotSpotReplacementsUtil.getFieldOffset(sha1type, "state"), JavaKind.Object, LocationIdentity.any());
            Word stateAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(state, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int)));
            return HotSpotBackend.shaImplCompressMBStub(bufAddr, stateAddr, ofs, limit);
        }
        if (DigestBaseSnippets.useSHA256Intrinsics(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && InstanceOfNode.doInstanceof(sha256type, realReceiver)) {
            Object sha256obj = PiNode.piCast(realReceiver, sha256type, false, true, SnippetAnchorNode.anchor());
            Object state = RawLoadNode.load(sha256obj, HotSpotReplacementsUtil.getFieldOffset(sha256type, "state"), JavaKind.Object, LocationIdentity.any());
            Word stateAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(state, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int)));
            return HotSpotBackend.sha2ImplCompressMBStub(bufAddr, stateAddr, ofs, limit);
        }
        if (DigestBaseSnippets.useSHA512Intrinsics(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && InstanceOfNode.doInstanceof(sha512type, realReceiver)) {
            Object sha512obj = PiNode.piCast(realReceiver, sha512type, false, true, SnippetAnchorNode.anchor());
            Object state = RawLoadNode.load(sha512obj, HotSpotReplacementsUtil.getFieldOffset(sha512type, "state"), JavaKind.Object, LocationIdentity.any());
            Word stateAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(state, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Long)));
            return HotSpotBackend.sha5ImplCompressMBStub(bufAddr, stateAddr, ofs, limit);
        }
        if (DigestBaseSnippets.useSHA3Intrinsics(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && InstanceOfNode.doInstanceof(sha3type, realReceiver)) {
            Object sha3obj = PiNode.piCast(realReceiver, sha3type, false, true, SnippetAnchorNode.anchor());
            int blockSize = RawLoadNode.loadInt(sha3obj, HotSpotReplacementsUtil.getFieldOffset(sha3type, "blockSize"), JavaKind.Int, LocationIdentity.any());
            Object state = RawLoadNode.load(sha3obj, HotSpotReplacementsUtil.getFieldOffset(sha3type, "state"), JavaKind.Object, LocationIdentity.any());
            Word stateAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(state, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Long)));
            return HotSpotBackend.sha3ImplCompressMBStub(bufAddr, stateAddr, blockSize, ofs, limit);
        }
        return FallbackInvokeWithExceptionNode.fallbackFunctionCallInt();
    }

    @Fold
    public static boolean useMD5Intrinsics(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.md5ImplCompressMultiBlock != 0L;
    }

    @Fold
    public static boolean useSHA1Intrinsics(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.sha1ImplCompressMultiBlock != 0L;
    }

    @Fold
    public static boolean useSHA256Intrinsics(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.sha256ImplCompressMultiBlock != 0L;
    }

    @Fold
    public static boolean useSHA512Intrinsics(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.sha512ImplCompressMultiBlock != 0L;
    }

    @Fold
    public static boolean useSHA3Intrinsics(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.sha3ImplCompressMultiBlock != 0L;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo implCompressMultiBlock0;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.implCompressMultiBlock0 = this.snippet(providers, DigestBaseSnippets.class, "implCompressMultiBlock0", new LocationIdentity[0]);
        }
    }
}

