/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.replacements.HubGetClassNode;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConvertNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public final class ClassGetHubNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
ConvertNode {
    public static final NodeClass<ClassGetHubNode> TYPE = NodeClass.create(ClassGetHubNode.class);
    @Node.Input
    protected ValueNode clazz;

    public ClassGetHubNode(ValueNode clazz) {
        super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)KlassPointerStamp.klass());
        this.clazz = clazz;
    }

    public static ValueNode create(ValueNode clazz, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        return ClassGetHubNode.canonical(null, metaAccess, constantReflection, false, KlassPointerStamp.klass(), clazz);
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode clazz) {
        ValueNode clazzValue = ClassGetHubNode.create(clazz, b.getMetaAccess(), b.getConstantReflection());
        b.push(JavaKind.Object, b.append(clazzValue));
        return true;
    }

    public static ValueNode canonical(ClassGetHubNode classGetHubNode, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, boolean allUsagesAvailable, Stamp stamp, ValueNode clazz) {
        ResolvedJavaType exactType;
        ClassGetHubNode self = classGetHubNode;
        if (allUsagesAvailable && self != null && self.hasNoUsages()) {
            return null;
        }
        if (clazz.isConstant() && !clazz.isNullConstant() && (exactType = constantReflection.asJavaType(clazz.asConstant())) != null && metaAccess != null) {
            if (exactType.isPrimitive()) {
                return ConstantNode.forConstant(stamp, (Constant)JavaConstant.NULL_POINTER, metaAccess);
            }
            return ConstantNode.forConstant(stamp, constantReflection.asObjectHub(exactType), metaAccess);
        }
        if (clazz instanceof GetClassNode) {
            GetClassNode getClass = (GetClassNode)clazz;
            return new LoadHubNode(KlassPointerStamp.klassNonNull(), getClass.getObject());
        }
        if (clazz instanceof HubGetClassNode) {
            return ((HubGetClassNode)clazz).getHub();
        }
        if (self == null) {
            self = new ClassGetHubNode(clazz);
        }
        return self;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        return ClassGetHubNode.canonical(this, tool.getMetaAccess(), tool.getConstantReflection(), tool.allUsagesAvailable(), this.stamp(NodeView.DEFAULT), this.clazz);
    }

    @Node.NodeIntrinsic
    public static native KlassPointer readClass(Class<?> var0);

    public static KlassPointer piCastNonNull(KlassPointer object, GuardingNode anchor) {
        return ClassGetHubNode.intrinsifiedPiNode(object, anchor, PiNode.IntrinsifyOp.NON_NULL);
    }

    @Node.NodeIntrinsic(value=PiNode.class)
    private static native KlassPointer intrinsifiedPiNode(KlassPointer var0, GuardingNode var1, @Node.ConstantNodeParameter PiNode.IntrinsifyOp var2);

    @Override
    public ValueNode getValue() {
        return this.clazz;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        ResolvedJavaType exactType = constantReflection.asJavaType(c);
        if (exactType.isPrimitive()) {
            return JavaConstant.NULL_POINTER;
        }
        return constantReflection.asObjectHub(exactType);
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        assert (!c.equals((Object)JavaConstant.NULL_POINTER));
        ResolvedJavaType objectType = constantReflection.asJavaType(c);
        return constantReflection.asJavaClass(objectType);
    }

    @Override
    public boolean isLossless() {
        return false;
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return false;
    }

    @Override
    public boolean preservesOrder(CanonicalCondition op, Constant value, ConstantReflectionProvider constantReflection) {
        assert (op == CanonicalCondition.EQ) : op;
        ResolvedJavaType exactType = constantReflection.asJavaType(value);
        return !exactType.isPrimitive();
    }
}

