/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;

@NodeInfo
public final class CallSiteTargetNode
extends MacroNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<CallSiteTargetNode> TYPE = NodeClass.create(CallSiteTargetNode.class);

    public CallSiteTargetNode(MacroNode.MacroParams p) {
        super(TYPE, p);
    }

    private ValueNode getCallSite() {
        return (ValueNode)this.arguments.get(0);
    }

    public static ConstantNode tryFold(ValueNode callSite, MetaAccessProvider metaAccess, Assumptions assumptions) {
        HotSpotObjectConstant c;
        JavaConstant target;
        if (callSite != null && callSite.isConstant() && !callSite.isNullConstant() && (target = (c = (HotSpotObjectConstant)callSite.asConstant()).getCallSiteTarget(assumptions)) != null) {
            return ConstantNode.forConstant(target, metaAccess);
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ConstantNode target = CallSiteTargetNode.tryFold(this.getCallSite(), tool.getMetaAccess(), this.graph().getAssumptions());
        if (target != null) {
            return target;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        ConstantNode target = CallSiteTargetNode.tryFold(this.getCallSite(), tool.getMetaAccess(), this.graph().getAssumptions());
        if (target != null) {
            this.graph().replaceFixedWithFloating(this, target);
        } else {
            super.lower(tool);
        }
    }
}

