/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes.type;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.hotspot.nodes.type.MetaspacePointerStamp;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;

public final class MethodCountersPointerStamp
extends MetaspacePointerStamp {
    private static final MethodCountersPointerStamp METHOD_COUNTERS = new MethodCountersPointerStamp(false, false);
    private static final MethodCountersPointerStamp METHOD_COUNTERS_NON_NULL = new MethodCountersPointerStamp(true, false);
    private static final MethodCountersPointerStamp METHOD_COUNTERS_ALWAYS_NULL = new MethodCountersPointerStamp(false, true);

    public static MethodCountersPointerStamp methodCounters() {
        return METHOD_COUNTERS;
    }

    private MethodCountersPointerStamp(boolean nonNull, boolean alwaysNull) {
        super(nonNull, alwaysNull);
    }

    @Override
    protected AbstractPointerStamp copyWith(boolean newNonNull, boolean newAlwaysNull) {
        if (newNonNull) {
            assert (!newAlwaysNull) : "New must not be always null";
            return METHOD_COUNTERS_NON_NULL;
        }
        if (newAlwaysNull) {
            return METHOD_COUNTERS_ALWAYS_NULL;
        }
        return METHOD_COUNTERS;
    }

    @Override
    public boolean isCompatible(Stamp otherStamp) {
        if (this == otherStamp) {
            return true;
        }
        return otherStamp instanceof MethodCountersPointerStamp;
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        if (JavaConstant.NULL_POINTER.equals((Object)c)) {
            return METHOD_COUNTERS_ALWAYS_NULL;
        }
        assert (c instanceof HotSpotMetaspaceConstant) : c;
        return METHOD_COUNTERS_NON_NULL;
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder("MethodCounters*");
        this.appendString(ret);
        return ret.toString();
    }
}

