/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.hotspot.nodes.StubStartNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="StubForeignCall#{p#descriptor/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the runtime cost of a call; it's a blackhole.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Can only dynamically decide how much code is generated based on the type of a call (special, static, virtual, interface).")
public final class StubForeignCallNode
extends FixedWithNextNode
implements LIRLowerable,
MultiMemoryKill {
    public static final NodeClass<StubForeignCallNode> TYPE = NodeClass.create(StubForeignCallNode.class);
    @Node.Input
    NodeInputList<ValueNode> arguments;
    protected final ForeignCallDescriptor descriptor;

    public StubForeignCallNode(@Node.InjectedNodeParameter Stamp stamp, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.descriptor = descriptor;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        LocationIdentity[] killedLocations = this.descriptor.getKilledLocations();
        killedLocations = Arrays.copyOf(killedLocations, killedLocations.length + 1);
        killedLocations[killedLocations.length - 1] = HotSpotReplacementsUtil.PENDING_EXCEPTION_LOCATION;
        return killedLocations;
    }

    protected Value[] operands(NodeLIRBuilderTool gen) {
        Value[] operands = new Value[this.arguments.size()];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = gen.operand((Node)this.arguments.get(i));
        }
        return operands;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.graph().start() instanceof StubStartNode) : Assertions.errorMessage(this, this.graph().start());
        ForeignCallLinkage linkage = gen.getLIRGeneratorTool().getForeignCalls().lookupForeignCall(this.descriptor);
        Value[] operands = this.operands(gen);
        Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, operands);
        if (result != null) {
            gen.setResult(this, (Value)result);
        }
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + String.valueOf(this.descriptor);
        }
        return super.toString(verbosity);
    }
}

