/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.DeoptimizingFixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_16)
public class KlassFullyInitializedCheckNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<KlassFullyInitializedCheckNode> TYPE = NodeClass.create(KlassFullyInitializedCheckNode.class);
    @Node.Input
    protected ValueNode klass;

    public KlassFullyInitializedCheckNode(ValueNode klassNonNull) {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)TYPE, StampFactory.forVoid());
        Stamp inputStamp = klassNonNull.stamp(NodeView.DEFAULT);
        assert (inputStamp instanceof AbstractPointerStamp) : String.valueOf(klassNonNull) + " has wrong input stamp type for klass init state check: " + String.valueOf(inputStamp);
        assert (((AbstractPointerStamp)inputStamp).nonNull()) : String.valueOf(klassNonNull) + " must have non-null stamp: " + String.valueOf(inputStamp);
        this.klass = klassNonNull;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.ANY_LOCATION;
    }

    public ValueNode getKlass() {
        return this.klass;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }
}

