/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(nameTemplate="{p#op/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class HotSpotCompressionNode
extends CompressionNode {
    public static final NodeClass<HotSpotCompressionNode> TYPE = NodeClass.create(HotSpotCompressionNode.class);

    public HotSpotCompressionNode(CompressionNode.CompressionOp op, ValueNode input, CompressEncoding encoding) {
        super(TYPE, op, input, HotSpotNarrowOopStamp.mkStamp(op, input.stamp(NodeView.DEFAULT), encoding), encoding);
    }

    public static HotSpotCompressionNode compress(StructuredGraph graph, ValueNode input, CompressEncoding encoding) {
        return graph.unique(HotSpotCompressionNode.compress(input, encoding));
    }

    public static CompressionNode uncompress(StructuredGraph graph, ValueNode input, CompressEncoding encoding) {
        return graph.unique(HotSpotCompressionNode.uncompress(input, encoding));
    }

    private static HotSpotCompressionNode compress(ValueNode input, CompressEncoding encoding) {
        return new HotSpotCompressionNode(CompressionNode.CompressionOp.Compress, input, encoding);
    }

    private static CompressionNode uncompress(ValueNode input, CompressEncoding encoding) {
        return new HotSpotCompressionNode(CompressionNode.CompressionOp.Uncompress, input, encoding);
    }

    @Override
    public boolean isCompressible(Constant constant) {
        if (JavaVersionUtil.JAVA_SPEC >= 24 && constant instanceof HotSpotMetaspaceConstant) {
            HotSpotMetaspaceConstant mc = (HotSpotMetaspaceConstant)constant;
            HotSpotResolvedObjectType type = mc.asResolvedJavaType();
            return type.isArray() || !type.isAbstract() && !type.isInterface();
        }
        return true;
    }

    @Override
    protected Constant compress(Constant c) {
        HotSpotConstant hc;
        if (JavaConstant.NULL_POINTER.equals((Object)c)) {
            return HotSpotCompressedNullConstant.COMPRESSED_NULL;
        }
        if (c instanceof HotSpotConstant && this.isCompressible((Constant)(hc = (HotSpotConstant)c))) {
            return hc.compress();
        }
        throw GraalError.shouldNotReachHere("invalid constant input for compress op: " + String.valueOf(c));
    }

    @Override
    protected Constant uncompress(Constant c) {
        if (c instanceof HotSpotConstant) {
            return ((HotSpotConstant)c).uncompress();
        }
        throw GraalError.shouldNotReachHere("invalid constant input for uncompress op: " + String.valueOf(c));
    }

    @Override
    public ValueNode reverse(ValueNode input) {
        switch (this.op) {
            case Compress: {
                return HotSpotCompressionNode.uncompress(input, this.encoding);
            }
            case Uncompress: {
                return HotSpotCompressionNode.compress(input, this.encoding);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
    }

    @Override
    protected Stamp mkStamp(Stamp input) {
        return HotSpotNarrowOopStamp.mkStamp(this.op, input, this.encoding);
    }

    @Override
    public boolean preservesOrder(CanonicalCondition condition, Constant constant, ConstantReflectionProvider constantReflection) {
        return this.isCompressible(constant) && super.preservesOrder(condition, constant, constantReflection);
    }
}

