/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.util.ListIterator;
import java.util.Optional;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotGraphBuilderPhase;
import jdk.graal.compiler.hotspot.lir.HotSpotZapRegistersPhase;
import jdk.graal.compiler.hotspot.lir.VerifyMaxRegisterSizePhase;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.java.SuitesProviderBase;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.SimplifyingGraphDecoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.AddressLoweringPhase;
import jdk.graal.compiler.phases.common.UseTrappingNullChecksPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.tiers.SuitesCreator;
import jdk.vm.ci.code.Architecture;

public class HotSpotSuitesProvider
extends SuitesProviderBase {
    protected final GraalHotSpotVMConfig config;
    protected final HotSpotGraalRuntimeProvider runtime;
    protected final SuitesCreator defaultSuitesCreator;

    public HotSpotSuitesProvider(SuitesCreator defaultSuitesCreator, GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime) {
        this.defaultSuitesCreator = defaultSuitesCreator;
        this.config = config;
        this.runtime = runtime;
        this.defaultGraphBuilderSuite = this.createGraphBuilderSuite();
    }

    @Override
    public Suites createSuites(OptionValues options, Architecture arch) {
        Suites suites = this.defaultSuitesCreator.createSuites(options, arch);
        if (this.runtime.getTarget().implicitNullCheckLimit > 0 && !this.runtime.getCompilerConfigurationName().equalsIgnoreCase("economy")) {
            ListIterator<BasePhase<LowTierContext>> position = suites.getLowTier().findPhase(AddressLoweringPhase.class);
            assert (position != null) : "There should be an " + AddressLoweringPhase.class.getName() + " in low tier.";
            position.previous();
            position.add(new UseTrappingNullChecksPhase());
        }
        return suites;
    }

    protected PhaseSuite<HighTierContext> createGraphBuilderSuite() {
        PhaseSuite<HighTierContext> suite = this.defaultSuitesCreator.getDefaultGraphBuilderSuite().copy();
        assert (this.appendGraphEncoderTest(suite));
        return suite;
    }

    private boolean appendGraphEncoderTest(PhaseSuite<HighTierContext> suite) {
        if (this.config.xcompMode) {
            return true;
        }
        suite.appendPhase(new BasePhase<HighTierContext>(){

            @Override
            public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
                return ALWAYS_APPLICABLE;
            }

            @Override
            protected void run(StructuredGraph graph, HighTierContext context) {
                EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graph, HotSpotSuitesProvider.this.runtime.getTarget().arch);
                StructuredGraph targetGraph = new StructuredGraph.Builder(graph.getOptions(), graph.getDebug(), StructuredGraph.AllowAssumptions.YES).method(graph.method()).trackNodeSourcePosition(graph.trackNodeSourcePosition()).profileProvider(graph.getProfileProvider()).build();
                SimplifyingGraphDecoder graphDecoder = new SimplifyingGraphDecoder(HotSpotSuitesProvider.this.runtime.getTarget().arch, targetGraph, context, true);
                graphDecoder.decode(encodedGraph);
            }

            @Override
            public CharSequence getName() {
                return "VerifyEncodingDecodingPhase";
            }
        });
        return true;
    }

    public static PhaseSuite<HighTierContext> withNodeSourcePosition(PhaseSuite<HighTierContext> gbs) {
        PhaseSuite<HighTierContext> newGbs = gbs.copy();
        GraphBuilderPhase graphBuilderPhase = (GraphBuilderPhase)newGbs.findPhase(GraphBuilderPhase.class).previous();
        GraphBuilderConfiguration graphBuilderConfig = graphBuilderPhase.getGraphBuilderConfig();
        HotSpotGraphBuilderPhase newGraphBuilderPhase = new HotSpotGraphBuilderPhase(graphBuilderConfig.withNodeSourcePosition(true));
        newGbs.findPhase(GraphBuilderPhase.class).set(newGraphBuilderPhase);
        return newGbs;
    }

    @Override
    public LIRSuites createLIRSuites(OptionValues options) {
        LIRSuites suites = this.defaultSuitesCreator.createLIRSuites(options);
        if (Assertions.detailedAssertionsEnabled(options)) {
            suites.getPostAllocationOptimizationStage().appendPhase(new HotSpotZapRegistersPhase());
        }
        if (Assertions.assertionsEnabled() && this.config.maxVectorSize >= 16) {
            suites.getFinalCodeAnalysisStage().appendPhase(new VerifyMaxRegisterSizePhase(this.config.maxVectorSize));
        }
        return suites;
    }
}

