/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Objects;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotReplacementsImpl;
import jdk.graal.compiler.hotspot.SnippetObjectConstant;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageInfo;

public class HotSpotSnippetReflectionProvider
implements SnippetReflectionProvider {
    private final HotSpotGraalRuntimeProvider runtime;
    private final HotSpotConstantReflectionProvider constantReflection;
    private final WordTypes wordTypes;
    private Class<?> wordTypesType;
    private Class<?> runtimeType;
    private Class<?> configType;

    public HotSpotSnippetReflectionProvider(HotSpotGraalRuntimeProvider runtime, HotSpotConstantReflectionProvider constantReflection, WordTypes wordTypes) {
        this.runtime = runtime;
        this.constantReflection = constantReflection;
        this.wordTypes = wordTypes;
    }

    @Override
    public JavaConstant forObject(Object object) {
        if (ImageInfo.inImageRuntimeCode()) {
            HotSpotReplacementsImpl.getEncodedSnippets().lookupSnippetType(object.getClass());
            return new SnippetObjectConstant(object);
        }
        return this.constantReflection.forObject(object);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        if (constant instanceof HotSpotObjectConstant) {
            HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
            return (T)hsConstant.asObject(type);
        }
        if (constant instanceof SnippetObjectConstant) {
            SnippetObjectConstant snippetObject = (SnippetObjectConstant)constant;
            return snippetObject.asObject(type);
        }
        return null;
    }

    @Override
    public JavaConstant forBoxed(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return this.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    @Override
    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        GraalHotSpotVMConfig config = this.runtime.getVMConfig();
        if (this.configType == null || this.wordTypesType == null || this.runtimeType == null) {
            this.wordTypesType = this.wordTypes.getClass();
            this.runtimeType = this.runtime.getClass();
            this.configType = config.getClass();
        }
        if (type.isAssignableFrom(this.wordTypesType)) {
            return type.cast(this.wordTypes);
        }
        if (type.isAssignableFrom(this.runtimeType)) {
            return type.cast(this.runtime);
        }
        if (type.isAssignableFrom(this.configType)) {
            return type.cast(config);
        }
        return null;
    }

    @Override
    public Class<?> originalClass(ResolvedJavaType type) {
        return HotSpotJVMCIRuntime.runtime().getMirror(type);
    }

    @Override
    public Executable originalMethod(ResolvedJavaMethod method) {
        Objects.requireNonNull(method);
        GraalError.guarantee(method instanceof HotSpotResolvedJavaMethod, "Unexpected implementation class: %s", (Object)method.getClass());
        if (method.isClassInitializer()) {
            return null;
        }
        return HotSpotJVMCIRuntime.runtime().getMirror(method);
    }

    @Override
    public Field originalField(ResolvedJavaField field) {
        Objects.requireNonNull(field);
        GraalError.guarantee(field instanceof HotSpotResolvedJavaField, "Unexpected implementation class: %s", (Object)field.getClass());
        return HotSpotJVMCIRuntime.runtime().getMirror(field);
    }
}

