/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.vm.ci.code.Register;

public class HotSpotRegisters
implements HotSpotRegistersProvider {
    private final Register threadRegister;
    private final Register heapBaseRegister;
    private final Register stackPointerRegister;

    public HotSpotRegisters(Register threadRegister, Register heapBaseRegister, Register stackPointerRegister) {
        this.threadRegister = threadRegister;
        this.heapBaseRegister = heapBaseRegister;
        this.stackPointerRegister = stackPointerRegister;
    }

    @Override
    public Register getThreadRegister() {
        assert (!this.threadRegister.equals((Object)Register.None)) : "thread register is not defined";
        return this.threadRegister;
    }

    @Override
    public Register getHeapBaseRegister() {
        assert (!this.heapBaseRegister.equals((Object)Register.None)) : "heap base register is not defined";
        return this.heapBaseRegister;
    }

    @Override
    public Register getStackPointerRegister() {
        assert (!this.stackPointerRegister.equals((Object)Register.None)) : "stack pointer register is not defined";
        return this.stackPointerRegister;
    }

    @Override
    public Register getZeroValueRegister(GraalHotSpotVMConfig config) {
        if (config.useCompressedOops && !config.getOopEncoding().hasBase()) {
            return this.getHeapBaseRegister();
        }
        return Register.None;
    }
}

