/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;

public class HotSpotPlatformConfigurationProvider
implements PlatformConfigurationProvider {
    private final BarrierSet barrierSet;
    private final boolean canVirtualizeLargeByteArrayAccess;
    private final boolean useLightweightLocking;

    public HotSpotPlatformConfigurationProvider(GraalHotSpotVMConfig config, BarrierSet barrierSet) {
        this.barrierSet = barrierSet;
        this.canVirtualizeLargeByteArrayAccess = config.deoptimizationSupportLargeAccessByteArrayVirtualization;
        this.useLightweightLocking = HotSpotReplacementsUtil.useLightweightLocking(config);
    }

    @Override
    public boolean canVirtualizeLargeByteArrayAccess() {
        return this.canVirtualizeLargeByteArrayAccess;
    }

    @Override
    public boolean requiresStrictLockOrder() {
        return this.useLightweightLocking;
    }

    @Override
    public boolean areLocksSideEffectFree() {
        return false;
    }

    @Override
    public BarrierSet getBarrierSet() {
        return this.barrierSet;
    }
}

