/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HotSpotMetaAccessExtensionProvider
implements MetaAccessExtensionProvider {
    private final ConstantReflectionProvider constantReflection;
    private final ResolvedJavaType jlClassType;

    public HotSpotMetaAccessExtensionProvider(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        this.constantReflection = constantReflection;
        this.jlClassType = metaAccess.lookupJavaType(Class.class);
    }

    @Override
    public JavaKind getStorageKind(JavaType type) {
        return type.getJavaKind();
    }

    @Override
    public boolean canConstantFoldDynamicAllocation(ResolvedJavaType type) {
        return type.isArray() || type.isInitialized();
    }

    @Override
    public boolean isGuaranteedSafepoint(ResolvedJavaMethod method, boolean isDirect) {
        return true;
    }

    @Override
    public boolean canVirtualize(ResolvedJavaType instanceType) {
        return true;
    }

    @Override
    public ResolvedJavaField getStaticFieldForAccess(JavaConstant base, long offset, JavaKind accessKind) {
        if (accessKind.getSlotCount() <= 0) {
            throw new IllegalArgumentException("Unexpected access kind: " + String.valueOf(accessKind));
        }
        if (!(base instanceof HotSpotObjectConstant)) {
            return null;
        }
        HotSpotObjectConstant objectConstant = (HotSpotObjectConstant)base;
        ResolvedJavaType type = this.constantReflection.asJavaType((Constant)base);
        if (type == null || !objectConstant.getType().equals((Object)this.jlClassType)) {
            return null;
        }
        for (ResolvedJavaField field : type.getStaticFields()) {
            if ((long)field.getOffset() != offset || accessKind != field.getJavaKind()) continue;
            return field;
        }
        return null;
    }
}

