/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.lang.annotation.Annotation;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VolatileCallSite;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CRC32;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotExceptionDispatchPlugin;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotInvocationPluginProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotInvocationPlugins;
import jdk.graal.compiler.hotspot.meta.HotSpotJITClassInitializationPlugin;
import jdk.graal.compiler.hotspot.meta.HotSpotNodePlugin;
import jdk.graal.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import jdk.graal.compiler.hotspot.nodes.CurrentJavaThreadNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotStoreReservedReferenceNode;
import jdk.graal.compiler.hotspot.nodes.KlassFullyInitializedCheckNode;
import jdk.graal.compiler.hotspot.nodes.VirtualThreadUpdateJFRNode;
import jdk.graal.compiler.hotspot.replacements.CallSiteTargetNode;
import jdk.graal.compiler.hotspot.replacements.DigestBaseSnippets;
import jdk.graal.compiler.hotspot.replacements.FastNotifyNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotIdentityHashCodeNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotInvocationPluginHelper;
import jdk.graal.compiler.hotspot.replacements.HotSpotReflectionGetCallerClassNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.HubGetClassNode;
import jdk.graal.compiler.hotspot.replacements.ObjectCloneNode;
import jdk.graal.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import jdk.graal.compiler.hotspot.replacements.UnsafeSetMemoryNode;
import jdk.graal.compiler.hotspot.word.HotSpotWordTypes;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.BytecodeParserOptions;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.calc.XorNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.tiers.CompilerConfiguration;
import jdk.graal.compiler.replacements.InlineDuringParsingPlugin;
import jdk.graal.compiler.replacements.IntrinsicGraphBuilder;
import jdk.graal.compiler.replacements.InvocationPluginHelper;
import jdk.graal.compiler.replacements.MethodHandlePlugin;
import jdk.graal.compiler.replacements.NodeIntrinsificationProvider;
import jdk.graal.compiler.replacements.ReplacementsImpl;
import jdk.graal.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.StandardGraphBuilderPlugins;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyCallNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopySnippets;
import jdk.graal.compiler.replacements.nodes.AESNode;
import jdk.graal.compiler.replacements.nodes.CipherBlockChainingAESNode;
import jdk.graal.compiler.replacements.nodes.CounterModeAESNode;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.VectorizedHashCodeNode;
import jdk.graal.compiler.replacements.nodes.VectorizedMismatchNode;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.word.LocationIdentity;

public class HotSpotGraphBuilderPlugins {
    private static final SpeculationReasonGroup JVMTI_NOTIFY_ALLOCATE_INSTANCE = new SpeculationReasonGroup("JvmtiNotifyAllocateInstance", new Class[0]);

    public static GraphBuilderConfiguration.Plugins create(final HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, final GraalHotSpotVMConfig config, final HotSpotWordTypes wordTypes, final MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, final SnippetReflectionProvider snippetReflection, final HotSpotHostForeignCallsProvider foreignCalls, final ReplacementsImpl replacements, OptionValues options, final TargetDescription target, BarrierSet barrierSet) {
        final HotSpotInvocationPlugins invocationPlugins = new HotSpotInvocationPlugins(graalRuntime, config, compilerConfiguration, options, target);
        final GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendNodePlugin(new HotSpotExceptionDispatchPlugin(config, wordTypes.getWordKind()));
        StandardGraphBuilderPlugins.registerConstantFieldLoadPlugin(plugins);
        if (!ImageInfo.inImageRuntimeCode()) {
            HotSpotWordOperationPlugin wordOperationPlugin = new HotSpotWordOperationPlugin(snippetReflection, constantReflection, wordTypes, barrierSet);
            HotSpotNodePlugin nodePlugin = new HotSpotNodePlugin(wordOperationPlugin);
            plugins.appendTypePlugin(nodePlugin);
            plugins.appendNodePlugin(nodePlugin);
        }
        plugins.appendNodePlugin(new MethodHandlePlugin(constantReflection.getMethodHandleAccess(), !config.supportsMethodHandleDeoptimizationEntry()));
        plugins.appendInlineInvokePlugin(replacements);
        if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        if (config.instanceKlassInitThreadOffset != -1) {
            plugins.setClassInitializationPlugin(new HotSpotJITClassInitializationPlugin());
        }
        compilerConfiguration.registerGraphBuilderPlugins(target.arch, plugins, options, replacements);
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                HotSpotGraphBuilderPlugins.registerObjectPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerClassPlugins(plugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSystemPlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerThreadPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerVirtualThreadPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerContinuationPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCallSitePlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerReflectionPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerAESPlugins(invocationPlugins, config, replacements, target.arch);
                HotSpotGraphBuilderPlugins.registerAdler32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32CPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSHAPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBase64Plugins(invocationPlugins, config, metaAccess, replacements);
                HotSpotGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, replacements, config);
                StandardGraphBuilderPlugins.registerInvocationPlugins(snippetReflection, invocationPlugins, replacements, true, false, true, graalRuntime.getHostProviders().getLowerer());
                HotSpotGraphBuilderPlugins.registerArrayPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements, wordTypes, foreignCalls, config);
                HotSpotGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins, replacements, target.arch);
                HotSpotGraphBuilderPlugins.registerReferencePlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerTrufflePlugins(invocationPlugins, wordTypes, config);
                HotSpotGraphBuilderPlugins.registerInstrumentationImplPlugins(invocationPlugins, config, replacements);
                for (HotSpotInvocationPluginProvider p : GraalServices.load(HotSpotInvocationPluginProvider.class)) {
                    p.registerInvocationPlugins(target.arch, plugins.getInvocationPlugins(), replacements);
                }
                HotSpotGraphBuilderPlugins.registerPoly1305Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerChaCha20Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerP256Plugins(invocationPlugins, config, replacements);
            }
        });
        if (!ImageInfo.inImageRuntimeCode()) {
            NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(metaAccess, snippetReflection, foreignCalls, wordTypes, target);
            invocationPlugins.defer(() -> {
                for (GeneratedPluginFactory factory : GraalServices.load(GeneratedPluginFactory.class)) {
                    factory.registerPlugins(invocationPlugins, nodeIntrinsificationProvider);
                }
            });
        }
        return plugins;
    }

    private static void registerTrufflePlugins(InvocationPlugins plugins, final WordTypes wordTypes, final GraalHotSpotVMConfig config) {
        if (config.jvmciReservedReference0Offset == -1) {
            return;
        }
        plugins.registerIntrinsificationPredicate(t -> t.getName().equals("Lcom/oracle/truffle/runtime/hotspot/HotSpotFastThreadLocal;"));
        InvocationPlugins.Registration tl = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.runtime.hotspot.HotSpotFastThreadLocal");
        tl.register(new InvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                receiver.get(true);
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.addPush(JavaKind.Object, new HotSpotLoadReservedReferenceNode(b.getMetaAccess(), wordTypes, jvmciReservedReference0Offset));
                return true;
            }
        });
        tl.register(new InvocationPlugin("set", new Type[]{InvocationPlugin.Receiver.class, Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                receiver.get(true);
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.add(new HotSpotStoreReservedReferenceNode(wordTypes, value, jvmciReservedReference0Offset));
                return true;
            }
        });
    }

    private static void registerObjectPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("clone", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get(true);
                b.addPush(JavaKind.Object, new ObjectCloneNode(MacroNode.MacroParams.of(b, targetMethod, object)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("hashCode", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get(true);
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }
        });
        if (config.inlineNotify()) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("notify", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get(true);
                    b.add(new FastNotifyNode(object, false, b.bci()));
                    return true;
                }
            });
        }
        if (config.inlineNotifyAll()) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("notifyAll", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get(true);
                    b.add(new FastNotifyNode(object, true, b.bci()));
                    return true;
                }
            });
        }
    }

    private static void registerClassPlugins(GraphBuilderConfiguration.Plugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)((Object)Class.class), replacements);
        r.register(new InvocationPlugin("getModifiers", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get(true));
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    helper.emitFinalReturn(JavaKind.Int, helper.readKlassModifierFlags(nonNullKlass));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("isInterface", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get(true));
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("isPrimitive", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get(true));
                    LogicNode isNull = b.add(IsNullNode.create(klass));
                    b.addPush(JavaKind.Boolean, ConditionalNode.create(isNull, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("getSuperclass", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get(true));
                    ConstantNode nullValue = ConstantNode.defaultForKind(JavaKind.Object);
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, nullValue, 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitReturnIfNot(test, nullValue, 0.25);
                    ValueNode layoutHelper = helper.klassLayoutHelper(klassNonNull);
                    ResolvedJavaType objectType = b.getMetaAccess().lookupJavaType(Object.class);
                    ConstantNode objectClass = ConstantNode.forConstant(b.getConstantReflection().asJavaClass(objectType), b.getMetaAccess());
                    helper.emitReturnIf(layoutHelper, Condition.LT, ConstantNode.forInt(config.klassLayoutHelperNeutralValue), objectClass, 0.25);
                    ValueNode superKlass = helper.readKlassSuperKlass(klassNonNull);
                    PiNode superKlassNonNull = helper.emitNullReturnGuard(superKlass, nullValue, 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new HubGetClassNode(b.getMetaAccess(), superKlassNonNull));
                }
                return true;
            }
        });
        r.registerConditional(config.jvmAccIsHiddenClass != 0, new InvocationPlugin("isHidden", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get(true));
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode flags = JavaVersionUtil.JAVA_SPEC >= 24 ? helper.readKlassMiscFlags(nonNullKlass) : helper.readKlassAccessFlags(nonNullKlass);
                    LogicNode test = IntegerTestNode.create(flags, ConstantNode.forInt(config.jvmAccIsHiddenClass), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
    }

    private static void registerCallSitePlugins(InvocationPlugins plugins) {
        InvocationPlugin.InlineOnlyInvocationPlugin plugin = new InvocationPlugin.InlineOnlyInvocationPlugin("getTarget", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode callSite = receiver.get(true);
                ConstantNode folded = CallSiteTargetNode.tryFold(GraphUtil.originalValue(callSite, true), b.getMetaAccess(), b.getAssumptions());
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    b.addPush(JavaKind.Object, new CallSiteTargetNode(MacroNode.MacroParams.of(b, targetMethod, callSite)));
                }
                return true;
            }
        };
        plugins.register((Type)((Object)ConstantCallSite.class), plugin);
        plugins.register((Type)((Object)MutableCallSite.class), plugin);
        plugins.register((Type)((Object)VolatileCallSite.class), plugin);
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.reflect.Reflection", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getCallerClass", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotReflectionGetCallerClassNode(MacroNode.MacroParams.of(b, targetMethod, new ValueNode[0])));
                return true;
            }
        });
        r.register(new InvocationPlugin("getClassAccessFlags", new Type[]{Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(b.nullCheckedValue(arg));
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    helper.emitFinalReturn(JavaKind.Int, new AndNode(accessFlags, ConstantNode.forInt(config.jvmAccWrittenFlags)));
                }
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        r.register(new InvocationPlugin("copyMemory0", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode srcBase, ValueNode srcOffset, ValueNode destBase, ValueNode destOffset, ValueNode bytes) {
                b.add(new UnsafeCopyMemoryNode(receiver.get(true), srcBase, srcOffset, destBase, destOffset, bytes));
                return true;
            }
        });
        r.registerConditional(config.unsafeSetMemory != 0L, new InvocationPlugin("setMemory0", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, Long.TYPE, Byte.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode obj, ValueNode offset, ValueNode bytes, ValueNode value) {
                b.add(new UnsafeSetMemoryNode(receiver.get(true), obj, offset, bytes, value));
                return true;
            }
        });
        r.register(new InvocationPlugin("allocateInstance", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                if (config.shouldNotifyObjectAllocAddress != 0L) {
                    SpeculationLog speculationLog = b.getGraph().getSpeculationLog();
                    SpeculationLog.SpeculationReason speculationReason = JVMTI_NOTIFY_ALLOCATE_INSTANCE.createSpeculationReason(new Object[0]);
                    if (speculationLog == null || !speculationLog.maySpeculate(speculationReason)) {
                        return false;
                    }
                    try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                        OffsetAddressNode address = OffsetAddressNode.create(helper.asWord(config.shouldNotifyObjectAllocAddress));
                        ValueNode shouldPostVMObjectAlloc = b.add(new JavaReadNode(JavaKind.Int, address, LocationIdentity.ANY_LOCATION, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                        LogicNode testShouldPostVMObjectAlloc = IntegerEqualsNode.create(shouldPostVMObjectAlloc, ConstantNode.forInt(0), NodeView.DEFAULT);
                        FixedGuardNode guard = new FixedGuardNode(testShouldPostVMObjectAlloc, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateRecompile, speculationLog.speculate(speculationReason), false);
                        b.add(guard);
                    }
                }
                unsafe.get(true);
                ValidateNewInstanceClassNode clazzLegal = b.add(new ValidateNewInstanceClassNode(clazz));
                b.add(new KlassFullyInitializedCheckNode(clazzLegal));
                if (b.currentBlockCatchesOOME()) {
                    b.addPush(JavaKind.Object, new DynamicNewInstanceWithExceptionNode(clazzLegal, true));
                } else {
                    b.addPush(JavaKind.Object, new DynamicNewInstanceNode(clazzLegal, true));
                }
                return true;
            }
        });
    }

    private static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)System.class));
        r.register(new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_MILLIS, "currentTimeMillis", new Type[0]));
        r.register(new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_NANOS, "nanoTime", new Type[0]));
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("identityHashCode", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }
        });
        ArrayCopySnippets.registerSystemArraycopyPlugin(r);
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.setAllowOverwrite(true);
        r.register(new InvocationPlugin("newArray", new Type[]{Class.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode componentType, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode nonNullComponentType = b.nullCheckedValue(componentType);
                    ValueNode arrayClass = helper.loadArrayKlass(nonNullComponentType);
                    helper.doFallbackIf(IsNullNode.create(arrayClass), 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new DynamicNewArrayNode(nonNullComponentType, length, true));
                }
                return true;
            }
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final WordTypes wordTypes, final ArrayCopyForeignCalls foreignCalls, final GraalHotSpotVMConfig vmConfig) {
        InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
        utf16r.register(new InvocationPlugin("toBytes", new Type[]{char[].class, Integer.TYPE, Integer.TYPE}){
            private static final int MAX_LENGTH = 0x3FFFFFFF;

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                    helper.intrinsicRangeCheck(srcBegin, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.GT, ConstantNode.forInt(0x3FFFFFFF));
                    ValueNode valueLength = b.add(new ArrayLengthNode(value));
                    ValueNode limit = b.add(new SubNode(valueLength, length));
                    helper.intrinsicRangeCheck(srcBegin, Condition.GT, limit);
                    NewArrayNode newArray = new NewArrayNode(b.getMetaAccess().lookupJavaType(Byte.TYPE), b.add(new LeftShiftNode(length, ConstantNode.forInt(1))), false);
                    b.addPush(JavaKind.Object, newArray);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, newArray, ConstantNode.forInt(0), length, JavaKind.Char, LocationIdentity.init(), false, true, true, vmConfig.heapWordSize));
                    b.pop(JavaKind.Object);
                    b.addPush(JavaKind.Object, new PublishWritesNode(newArray));
                    b.add(MembarNode.forInitialization());
                }
                return true;
            }
        });
        utf16r.register(new InvocationPlugin("getChars", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode srcEnd, ValueNode dst, ValueNode dstBegin) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                    helper.emitReturnIf(srcBegin, Condition.GE, srcEnd, null, 0.010000000000000009);
                    ValueNode size = helper.sub(srcEnd, srcBegin);
                    ValueNode or = helper.or(srcBegin, size);
                    helper.intrinsicRangeCheck(or, Condition.LT, ConstantNode.forInt(0));
                    ValueNode srcLimit = helper.sub(helper.shr(helper.length(value), 1), srcBegin);
                    helper.intrinsicRangeCheck(size, Condition.GT, srcLimit);
                    ValueNode limit = helper.sub(helper.length(dst), size);
                    helper.intrinsicRangeCheck(dstBegin, Condition.GT, limit);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, dst, dstBegin, size, JavaKind.Char, JavaKind.Byte, JavaKind.Char, false, true, true, vmConfig.heapWordSize));
                    helper.emitFinalReturn(JavaKind.Void, null);
                }
                return true;
            }
        });
    }

    private static boolean isAnnotatedByChangesCurrentThread(ResolvedJavaMethod method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!"jdk.internal.vm.annotation.ChangesCurrentThread".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    private static AddressNode getScopedValueCacheAddress(GraphBuilderContext b, HotSpotInvocationPluginHelper helper) {
        CurrentJavaThreadNode javaThread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
        ValueNode scopedValueCacheHandle = helper.readJavaThreadScopedValueCache(javaThread);
        return b.add(OffsetAddressNode.create(scopedValueCacheHandle));
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        final BarrierSet barrierSet = replacements.getProviders().getPlatformConfigurationProvider().getBarrierSet();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register(new InvocationPlugin("currentThread", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    CurrentJavaThreadNode thread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                    ValueNode vthreadHandle = helper.readJavaThreadVthread(thread);
                    AddressNode handleAddress = b.add(OffsetAddressNode.create(vthreadHandle));
                    ObjectStamp threadStamp = StampFactory.objectNonNull(TypeReference.create(b.getAssumptions(), b.getMetaAccess().lookupJavaType(Thread.class)));
                    ReadNode read = new ReadNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_CURRENT_THREAD_OOP_HANDLE_LOCATION, threadStamp, barrierSet.readBarrierType(HotSpotReplacementsUtil.HOTSPOT_CURRENT_THREAD_OOP_HANDLE_LOCATION, handleAddress, threadStamp), MemoryOrderMode.PLAIN);
                    b.addPush(JavaKind.Object, read);
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("currentCarrierThread", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    CurrentJavaThreadNode thread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                    ValueNode cthreadHandle = helper.readJavaThreadThreadObj(thread);
                    AddressNode handleAddress = b.add(OffsetAddressNode.create(cthreadHandle));
                    ObjectStamp threadStamp = StampFactory.objectNonNull(TypeReference.create(b.getAssumptions(), b.getMetaAccess().lookupJavaType(Thread.class)));
                    ReadNode read = new ReadNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_CARRIER_THREAD_OOP_HANDLE_LOCATION, threadStamp, barrierSet.readBarrierType(HotSpotReplacementsUtil.HOTSPOT_CARRIER_THREAD_OOP_HANDLE_LOCATION, handleAddress, threadStamp), MemoryOrderMode.PLAIN);
                    b.addPush(JavaKind.Object, read);
                }
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("setCurrentThread", new Type[]{InvocationPlugin.Receiver.class, Thread.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode thread) {
                GraalError.guarantee(ImageInfo.inImageRuntimeCode() || HotSpotGraphBuilderPlugins.isAnnotatedByChangesCurrentThread(b.getMethod()), "method changes current Thread but is not annotated ChangesCurrentThread");
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    receiver.get(true);
                    CurrentJavaThreadNode javaThread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                    ValueNode threadObjectHandle = helper.readJavaThreadVthread(javaThread);
                    AddressNode handleAddress = b.add(OffsetAddressNode.create(threadObjectHandle));
                    b.add(new WriteNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_CURRENT_THREAD_OOP_HANDLE_LOCATION, thread, barrierSet.writeBarrierType(HotSpotReplacementsUtil.HOTSPOT_CURRENT_THREAD_OOP_HANDLE_LOCATION), MemoryOrderMode.PLAIN));
                    if (JavaVersionUtil.JAVA_SPEC > 21) {
                        GraalError.guarantee(config.javaThreadMonitorOwnerIDOffset != -1, "JavaThread::_lock_id should have been exported");
                        ValueNode monitorOwnerID = helper.loadField(thread, helper.getField(b.getMetaAccess().lookupJavaType(Thread.class), "tid"));
                        OffsetAddressNode address = b.add(new OffsetAddressNode(javaThread, helper.asWord(config.javaThreadMonitorOwnerIDOffset)));
                        b.add(new JavaWriteNode(JavaKind.Long, address, HotSpotReplacementsUtil.JAVA_THREAD_MONITOR_OWNER_ID_LOCATION, monitorOwnerID, BarrierType.NONE, false));
                    }
                    if (HotSpotReplacementsUtil.supportsVirtualThreadUpdateJFR(config)) {
                        b.add(new VirtualThreadUpdateJFRNode(thread));
                    }
                }
                return true;
            }
        });
        r.registerConditional(config.threadScopedValueCacheOffset != -1, new InvocationPlugin("scopedValueCache", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    AddressNode handleAddress = HotSpotGraphBuilderPlugins.getScopedValueCacheAddress(b, helper);
                    ObjectStamp stamp = StampFactory.object(TypeReference.create(b.getAssumptions(), b.getMetaAccess().lookupJavaType(Object[].class)));
                    b.push(JavaKind.Object, b.add(new ReadNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION, stamp, barrierSet.readBarrierType(HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION, handleAddress, stamp), MemoryOrderMode.PLAIN)));
                }
                return true;
            }
        });
        r.registerConditional(config.threadScopedValueCacheOffset != -1, new InvocationPlugin("setScopedValueCache", new Type[]{Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode cache) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    AddressNode handleAddress = HotSpotGraphBuilderPlugins.getScopedValueCacheAddress(b, helper);
                    b.add(new WriteNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION, cache, barrierSet.writeBarrierType(HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION), MemoryOrderMode.PLAIN));
                }
                return true;
            }
        });
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/79345bbbae2564f9f523859d1227a1784293b20f/src/hotspot/share/opto/library_call.cpp#L2920-L2974", sha1="353e0d45b0f63ac58af86dcab5b19777950da7e2")
    private static void inlineNativeNotifyJvmtiFunctions(GraalHotSpotVMConfig config, GraphBuilderContext b, ResolvedJavaMethod targetMethod, ForeignCallDescriptor descriptor, ValueNode virtualThread, ValueNode hide) {
        try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
            GraalError.guarantee(config.virtualThreadVTMSNotifyJvmtiEvents != -1L, "JvmtiVTMSTransitionDisabler::_VTMS_notify_jvmti_events is not exported");
            OffsetAddressNode address = OffsetAddressNode.create(helper.asWord(config.virtualThreadVTMSNotifyJvmtiEvents));
            ValueNode notifyJvmtiEnabled = b.add(new JavaReadNode(JavaKind.Boolean, address, HotSpotReplacementsUtil.HOTSPOT_VTMS_NOTIFY_JVMTI_EVENTS, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
            LogicNode testNotifyJvmtiEnabled = IntegerEqualsNode.create(notifyJvmtiEnabled, ConstantNode.forBoolean(true), NodeView.DEFAULT);
            StructuredGraph graph = b.getGraph();
            CurrentJavaThreadNode javaThread = graph.addOrUniqueWithInputs(new CurrentJavaThreadNode(helper.getWordKind()));
            BeginNode trueSuccessor = graph.add(new BeginNode());
            BeginNode falseSuccessor = graph.add(new BeginNode());
            b.add(new IfNode(testNotifyJvmtiEnabled, trueSuccessor, falseSuccessor, ProfileData.BranchProbabilityData.injected(0.09999999999999998)));
            ForeignCallNode runtimeCall = graph.add(new ForeignCallNode(descriptor, virtualThread, hide, javaThread));
            trueSuccessor.setNext(runtimeCall);
            runtimeCall.setStateAfter(b.getInvocationPluginReturnState(JavaKind.Void, null));
            EndNode trueSuccessorEnd = graph.add(new EndNode());
            runtimeCall.setNext(trueSuccessorEnd);
            GraalError.guarantee((long)config.threadIsInVTMSTransitionOffset != -1L, "JavaThread::_is_in_VTMS_transition is not exported");
            OffsetAddressNode jtAddress = graph.addOrUniqueWithInputs(new OffsetAddressNode(javaThread, helper.asWord(config.threadIsInVTMSTransitionOffset)));
            JavaWriteNode jtWrite = b.add(new JavaWriteNode(JavaKind.Boolean, jtAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_IS_IN_VTMS_TRANSITION, hide, BarrierType.NONE, false));
            falseSuccessor.setNext(jtWrite);
            GraalError.guarantee((long)config.javaLangThreadIsInVTMSTransitonOffset != -1L, "java_lang_Thread::_jvmti_is_in_VTMS_transition_offset is not exported");
            OffsetAddressNode vtAddress = graph.addOrUniqueWithInputs(new OffsetAddressNode(virtualThread, helper.asWord(config.javaLangThreadIsInVTMSTransitonOffset)));
            b.add(new JavaWriteNode(JavaKind.Boolean, vtAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_LANG_THREAD_IS_IN_VTMS_TRANSITION, hide, BarrierType.NONE, false));
            EndNode falseSuccessorEnd = b.add(new EndNode());
            MergeNode merge = b.add(new MergeNode());
            merge.addForwardEnd(trueSuccessorEnd);
            merge.addForwardEnd(falseSuccessorEnd);
        }
    }

    private static void registerContinuationPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.vm.Continuation", replacements);
        if (JavaVersionUtil.JAVA_SPEC >= 24) {
            r.register(new ContinuationPinningPlugin(config, true));
            r.register(new ContinuationPinningPlugin(config, false));
        }
    }

    private static void registerVirtualThreadPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.VirtualThread", replacements);
        if (config.supportJVMTIVThreadNotification()) {
            r.register(new InvocationPlugin("notifyJvmtiStart", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get(true);
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_START, nonNullReceiver, ConstantNode.forBoolean(false, b.getGraph()));
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiEnd", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get(true);
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_END, nonNullReceiver, ConstantNode.forBoolean(true, b.getGraph()));
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiMount", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode hide) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get(true);
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_MOUNT, nonNullReceiver, hide);
                    }
                    return true;
                }
            });
            r.register(new InvocationPlugin("notifyJvmtiUnmount", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode hide) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        ValueNode nonNullReceiver = receiver.get(true);
                        HotSpotGraphBuilderPlugins.inlineNativeNotifyJvmtiFunctions(config, b, targetMethod, HotSpotBackend.SHAREDRUNTIME_NOTIFY_JVMTI_VTHREAD_UNMOUNT, nonNullReceiver, hide);
                    }
                    return true;
                }
            });
        }
        if (JavaVersionUtil.JAVA_SPEC == 21) {
            r.register(new InvocationPlugin("notifyJvmtiHideFrames", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode hide) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                            receiver.get(true);
                            GraalError.guarantee(config.threadIsInTmpVTMSTransitionOffset != -1, "JavaThread::_is_in_tmp_VTMS_transition is not exported");
                            CurrentJavaThreadNode javaThread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                            OffsetAddressNode address = b.add(new OffsetAddressNode(javaThread, helper.asWord(config.threadIsInTmpVTMSTransitionOffset)));
                            b.add(new JavaWriteNode(JavaKind.Boolean, address, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_IS_IN_TMP_VTMS_TRANSITION, hide, BarrierType.NONE, false));
                        }
                    }
                    return true;
                }
            });
        }
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            Type[] typeArray;
            if (JavaVersionUtil.JAVA_SPEC >= 23) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Boolean.TYPE;
            } else {
                Type[] typeArray3 = new Type[2];
                typeArray3[0] = InvocationPlugin.Receiver.class;
                typeArray = typeArray3;
                typeArray3[1] = Boolean.TYPE;
            }
            Type[] notifyJvmtiDisableSuspendArgTypes = typeArray;
            r.register(new InvocationPlugin("notifyJvmtiDisableSuspend", notifyJvmtiDisableSuspendArgTypes){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode enter) {
                    if (config.doJVMTIVirtualThreadTransitions) {
                        try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                            if (JavaVersionUtil.JAVA_SPEC < 23) {
                                receiver.get(true);
                            }
                            GraalError.guarantee(config.threadIsDisableSuspendOffset != -1, "JavaThread::_is_disable_suspend is not exported");
                            CurrentJavaThreadNode javaThread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                            OffsetAddressNode address = b.add(new OffsetAddressNode(javaThread, helper.asWord(config.threadIsDisableSuspendOffset)));
                            b.add(new JavaWriteNode(JavaKind.Boolean, address, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_IS_DISABLE_SUSPEND, enter, BarrierType.NONE, false));
                        }
                    }
                    return true;
                }
            });
        }
    }

    private static ResolvedJavaType resolveTypeAESCrypt(ResolvedJavaType context) {
        return UnresolvedJavaType.create((String)"Lcom/sun/crypto/provider/AESCrypt;").resolve(context);
    }

    private static void registerAESPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
        r.registerConditional(CipherBlockChainingAESNode.isSupported(arch), new HotSpotCipherBlockChainingCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(CipherBlockChainingAESNode.isSupported(arch), new HotSpotCipherBlockChainingCryptPlugin(AESNode.CryptMode.DECRYPT));
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.ElectronicCodeBook", replacements);
        r.registerConditional(config.electronicCodeBookEncrypt != 0L, new ElectronicCodeBookCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(config.electronicCodeBookDecrypt != 0L, new ElectronicCodeBookCryptPlugin(AESNode.CryptMode.DECRYPT));
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GaloisCounterMode", replacements);
        r.registerConditional(config.galoisCounterModeCrypt != 0L, new GaloisCounterModeCryptPlugin());
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
        r.registerConditional(CounterModeAESNode.isSupported(arch), new StandardGraphBuilderPlugins.CounterModeCryptPlugin(){

            @Override
            protected boolean canApply(GraphBuilderContext b) {
                return b instanceof BytecodeParser || b instanceof IntrinsicGraphBuilder;
            }

            @Override
            protected ValueNode getFieldOffset(GraphBuilderContext b, ResolvedJavaField field) {
                return ConstantNode.forLong(field.getOffset());
            }

            @Override
            protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
                return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
            }
        });
    }

    private static void registerAdler32Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.Adler32", replacements);
        r.registerConditional(config.updateBytesAdler32 != 0L, new InvocationPlugin.InlineOnlyInvocationPlugin("updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode adler, ValueNode src, ValueNode off, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode addr = helper.arrayElementPointer(src, JavaKind.Byte, off);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_ADLER32, adler, addr, len);
                    b.addPush(JavaKind.Int, call);
                }
                return true;
            }
        });
        r.registerConditional(config.updateBytesAdler32 != 0L, new InvocationPlugin.InlineOnlyInvocationPlugin("updateByteBuffer", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode adler, ValueNode addr, ValueNode off, ValueNode len) {
                ValueNode buff = b.add(new ComputeObjectAddressNode(addr, off));
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_ADLER32, adler, buff, len);
                b.addPush(JavaKind.Int, call);
                return true;
            }
        });
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        r.registerConditional(config.montgomeryMultiply != 0L, new InvocationPlugin("implMontgomeryMultiply", new Type[]{int[].class, int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode bObject, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, product);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_MULTIPLY, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(bObject, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                }
                return true;
            }
        });
        r.registerConditional(config.montgomerySquare != 0L, new InvocationPlugin("implMontgomerySquare", new Type[]{int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, product);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_SQUARE, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                }
                return true;
            }
        });
        r.registerConditional(config.bigIntegerLeftShiftWorker != 0L, new InvocationPlugin("shiftLeftImplWorker", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newArr, ValueNode oldArr, ValueNode newIdx, ValueNode shiftCount, ValueNode numIter) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BIGINTEGER_LEFT_SHIFT_WORKER, helper.arrayStart(newArr, JavaKind.Int), helper.arrayStart(oldArr, JavaKind.Int), newIdx, shiftCount, numIter));
                }
                return true;
            }
        });
        r.registerConditional(config.bigIntegerRightShiftWorker != 0L, new InvocationPlugin("shiftRightImplWorker", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newArr, ValueNode oldArr, ValueNode newIdx, ValueNode shiftCount, ValueNode numIter) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BIGINTEGER_RIGHT_SHIFT_WORKER, helper.arrayStart(newArr, JavaKind.Int), helper.arrayStart(oldArr, JavaKind.Int), newIdx, shiftCount, numIter));
                }
                return true;
            }
        });
    }

    private static void registerSHAPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        boolean useMD5 = config.md5ImplCompressMultiBlock != 0L;
        boolean useSha1 = config.sha1ImplCompressMultiBlock != 0L;
        boolean useSha256 = config.sha256ImplCompressMultiBlock != 0L;
        boolean useSha512 = config.sha512ImplCompressMultiBlock != 0L;
        boolean useSha3 = config.sha3ImplCompressMultiBlock != 0L;
        boolean implCompressMultiBlock0Enabled = useMD5 || useSha1 || useSha256 || useSha512 || useSha3;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.security.provider.DigestBase", replacements);
        r.registerConditional(implCompressMultiBlock0Enabled, new SnippetSubstitutionInvocationPlugin<DigestBaseSnippets.Templates>(DigestBaseSnippets.Templates.class, "implCompressMultiBlock0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            protected Object[] getConstantArguments(ResolvedJavaMethod targetMethod) {
                ResolvedJavaType declaringClass = targetMethod.getDeclaringClass();
                return new Object[]{declaringClass, HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/MD5;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA2;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA5;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA3;")};
            }

            @Override
            public SnippetTemplate.SnippetInfo getSnippet(DigestBaseSnippets.Templates templates) {
                return templates.implCompressMultiBlock0;
            }
        });
    }

    private static void registerBase64Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Encoder", replacements);
        r.registerConditional(config.base64EncodeBlock != 0L, new InvocationPlugin("encodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                if (receiver != null) {
                    receiver.get(true);
                }
                int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_ENCODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Decoder", replacements);
        if (config.base64DecodeBlock != 0L) {
            r.register(new InvocationPlugin("decodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL, ValueNode isMime) {
                    if (receiver != null) {
                        receiver.get(true);
                    }
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                    ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_DECODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL, isMime);
                    b.addPush(JavaKind.Int, call);
                    return true;
                }
            });
        }
    }

    private static void registerCRC32Plugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)CRC32.class), replacements);
        r.registerConditional(config.updateBytesCRC32Stub != 0L && config.crcTableAddress != 0L, new InvocationPlugin("update", new Type[]{Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode arg) {
                ConstantNode crcTableRawAddress = ConstantNode.forLong(config.crcTableAddress);
                XorNode c = new XorNode(crc, ConstantNode.forInt(-1));
                AndNode index = new AndNode(new XorNode(arg, c), ConstantNode.forInt(255));
                LeftShiftNode offset = new LeftShiftNode(index, ConstantNode.forInt(2));
                OffsetAddressNode address = new OffsetAddressNode(crcTableRawAddress, new SignExtendNode(offset, 32, 64));
                ValueNode result = b.add(new JavaReadNode(JavaKind.Int, address, HotSpotBackend.CRC_TABLE_LOCATION, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                result = new XorNode(result, new UnsignedRightShiftNode(c, ConstantNode.forInt(8)));
                b.addPush(JavaKind.Int, new XorNode(result, ConstantNode.forInt(-1)));
                return true;
            }
        });
        r.registerConditional(config.updateBytesCRC32Stub != 0L, new InvocationPlugin("updateBytes0", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode len) {
                int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                ValueNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                return true;
            }
        });
        r.registerConditional(config.updateBytesCRC32Stub != 0L, new InvocationPlugin("updateByteBuffer0", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode len) {
                ValueNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                return true;
            }
        });
    }

    private static void registerCRC32CPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.CRC32C", replacements);
        r.registerConditional(config.updateBytesCRC32C != 0L, new InvocationPlugin("updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode end) {
                int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                ValueNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                return true;
            }
        });
        r.registerConditional(config.updateBytesCRC32C != 0L, new InvocationPlugin("updateDirectByteBuffer", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode end) {
                ValueNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                return true;
            }
        });
    }

    private static void registerPoly1305Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.Poly1305", replacements);
        r.registerConditional(config.poly1305ProcessBlocks != 0L, new InvocationPlugin("processMultipleBlocks", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, long[].class, long[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode input, ValueNode offset, ValueNode length, ValueNode aLimbs, ValueNode rLimbs) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    receiver.get(true);
                    ValueNode inputNotNull = b.nullCheckedValue(input);
                    ValueNode aLimbsNotNull = b.nullCheckedValue(aLimbs);
                    ValueNode rLimbsNotNull = b.nullCheckedValue(rLimbs);
                    ValueNode inputStart = helper.arrayElementPointer(inputNotNull, JavaKind.Byte, offset);
                    ValueNode aLimbsStart = helper.arrayStart(aLimbsNotNull, JavaKind.Long);
                    ValueNode rLimbsStart = helper.arrayStart(rLimbsNotNull, JavaKind.Long);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.POLY1305_PROCESSBLOCKS, inputStart, length, aLimbsStart, rLimbsStart));
                }
                return true;
            }
        });
    }

    private static void registerChaCha20Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.ChaCha20Cipher", replacements);
        r.registerConditional(config.chacha20Block != 0L, new InvocationPlugin("implChaCha20Block", new Type[]{int[].class, byte[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode initState, ValueNode result) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode stateNotNull = b.nullCheckedValue(initState);
                    ValueNode resultNotNull = b.nullCheckedValue(result);
                    ValueNode stateStart = helper.arrayStart(stateNotNull, JavaKind.Int);
                    ValueNode resultStart = helper.arrayStart(resultNotNull, JavaKind.Byte);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.CHACHA20Block, stateStart, resultStart);
                    b.addPush(JavaKind.Int, call);
                }
                return true;
            }
        });
    }

    private static void registerP256Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.security.util.math.intpoly.MontgomeryIntegerPolynomialP256", replacements);
        r.registerConditional(config.intpolyMontgomeryMultP256 != 0L, new InvocationPlugin("multImpl", new Type[]{InvocationPlugin.Receiver.class, long[].class, long[].class, long[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode aIn, ValueNode bIn, ValueNode rOut) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode aNotNull = b.nullCheckedValue(aIn);
                    ValueNode bNotNull = b.nullCheckedValue(bIn);
                    ValueNode rNotNull = b.nullCheckedValue(rOut);
                    ValueNode aStart = helper.arrayStart(aNotNull, JavaKind.Long);
                    ValueNode bStart = helper.arrayStart(bNotNull, JavaKind.Long);
                    ValueNode rStart = helper.arrayStart(rNotNull, JavaKind.Long);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.INTPOLY_MONTGOMERYMULT_P256, aStart, bStart, rStart));
                }
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "sun.security.util.math.intpoly.IntegerPolynomial", replacements);
        r.registerConditional(config.intpolyAssign != 0L, new InvocationPlugin("conditionalAssign", new Type[]{Integer.TYPE, long[].class, long[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode set, ValueNode aIn, ValueNode bIn) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode aNotNull = b.nullCheckedValue(aIn);
                    ValueNode bNotNull = b.nullCheckedValue(bIn);
                    ValueNode aStart = helper.arrayStart(aNotNull, JavaKind.Long);
                    ValueNode bStart = helper.arrayStart(bNotNull, JavaKind.Long);
                    ValueNode aLength = helper.arraylength(aNotNull);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.INTPOLY_ASSIGN, set, aStart, bStart, aLength));
                }
                return true;
            }
        });
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, Replacements replacements, final Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
        r.registerConditional(VectorizedMismatchNode.isSupported(arch), new InvocationPlugin("vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode aObject, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                ValueNode aAddr = b.add(new ComputeObjectAddressNode(aObject, aOffset));
                ValueNode bAddr = b.add(new ComputeObjectAddressNode(bObject, bOffset));
                b.addPush(JavaKind.Int, new VectorizedMismatchNode(aAddr, bAddr, length, log2ArrayIndexScale));
                return true;
            }

            @Override
            public boolean isGraalOnly() {
                return arch instanceof AArch64;
            }
        });
        r.registerConditional(VectorizedHashCodeNode.isSupported(arch), new StandardGraphBuilderPlugins.VectorizedHashCodeInvocationPlugin("vectorizedHashCode"){

            @Override
            public boolean isGraalOnly() {
                return arch instanceof AArch64;
            }
        });
    }

    private static void registerReferencePlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class), replacements);
        r.register(new StandardGraphBuilderPlugins.ReachabilityFencePlugin(){

            @Override
            protected boolean useExplicitReachabilityFence(GraphBuilderContext b) {
                return Options.ForceExplicitReachabilityFence.getValue(b.getOptions());
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("refersTo0", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                ValueNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                AddressNode address = b.add(new OffsetAddressNode(receiver.get(true), offset));
                FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, BarrierType.WEAK_REFERS_TO, MemoryOrderMode.PLAIN, true));
                LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }
        });
        if (JavaVersionUtil.JAVA_SPEC >= 24) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("clear0", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        ValueNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                        AddressNode address = b.add(new OffsetAddressNode(receiver.get(true), offset));
                        FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                        JavaReadNode referent = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, BarrierType.WEAK_REFERS_TO, MemoryOrderMode.PLAIN, true));
                        helper.emitReturnIf(IsNullNode.create(referent), null, 0.75);
                        b.add(new JavaWriteNode(JavaKind.Object, address, locationIdentity, ConstantNode.defaultForKind(JavaKind.Object), BarrierType.AS_NO_KEEPALIVE_WRITE, true));
                        helper.emitFinalReturn(JavaKind.Void, null);
                        boolean bl = true;
                        return bl;
                    }
                }
            });
        }
        r = new InvocationPlugins.Registration(plugins, (Type)((Object)PhantomReference.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("refersTo0", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                ValueNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                AddressNode address = b.add(new OffsetAddressNode(receiver.get(true), offset));
                FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, BarrierType.PHANTOM_REFERS_TO, MemoryOrderMode.PLAIN, true));
                LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }
        });
        if (JavaVersionUtil.JAVA_SPEC >= 24) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("clear0", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                        ValueNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                        AddressNode address = b.add(new OffsetAddressNode(receiver.get(true), offset));
                        FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                        JavaReadNode referent = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, BarrierType.PHANTOM_REFERS_TO, MemoryOrderMode.PLAIN, true));
                        helper.emitReturnIf(IsNullNode.create(referent), null, 0.75);
                        b.add(new JavaWriteNode(JavaKind.Object, address, locationIdentity, ConstantNode.defaultForKind(JavaKind.Object), BarrierType.AS_NO_KEEPALIVE_WRITE, true));
                        helper.emitFinalReturn(JavaKind.Void, null);
                        boolean bl = true;
                        return bl;
                    }
                }
            });
        }
    }

    private static void registerInstrumentationImplPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.instrument.InstrumentationImpl", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getObjectSize0", new Type[]{InvocationPlugin.Receiver.class, Long.TYPE, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode nativeAgent, ValueNode objectToSize) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode objectNonNull = b.nullCheckedValue(objectToSize);
                    StructuredGraph graph = b.getGraph();
                    receiver.get(true);
                    LoadHubNode hub = b.add(new LoadHubNode(b.getStampProvider(), objectNonNull));
                    ValueNode layoutHelper = helper.klassLayoutHelper(hub);
                    LogicNode isArray = b.add(ObjectIsArrayNode.create(objectNonNull));
                    ArrayLengthNode arrayLengthNode = graph.add(new ArrayLengthNode(objectNonNull));
                    EndNode arrayBranch = graph.add(new EndNode());
                    arrayLengthNode.setNext(arrayBranch);
                    ValueNode arrayHeaderSizeInt = b.add(UnsignedRightShiftNode.create(layoutHelper, ConstantNode.forInt(config.layoutHelperHeaderSizeShift), NodeView.DEFAULT));
                    ValueNode arrayHeaderSizeMaskedInt = b.add(AndNode.create(arrayHeaderSizeInt, ConstantNode.forInt(config.layoutHelperHeaderSizeMask), NodeView.DEFAULT));
                    ValueNode arrayHeaderSizeMaskedLong = b.add(SignExtendNode.create(arrayHeaderSizeMaskedInt, JavaKind.Long.getBitCount(), NodeView.DEFAULT));
                    ValueNode arrayLengthLong = b.add(SignExtendNode.create(arrayLengthNode, JavaKind.Long.getBitCount(), NodeView.DEFAULT));
                    ValueNode arraySizeLong = b.add(LeftShiftNode.create(arrayLengthLong, layoutHelper, NodeView.DEFAULT));
                    ValueNode arrayInstanceSizeLong = b.add(AddNode.create(arrayHeaderSizeMaskedLong, arraySizeLong, NodeView.DEFAULT));
                    long objectAlignmentMask = config.objectAlignment - 1;
                    ValueNode arrayInstanceSizeMaskedLong = b.add(AndNode.create(AddNode.create(arrayInstanceSizeLong, ConstantNode.forLong(objectAlignmentMask), NodeView.DEFAULT), ConstantNode.forLong(objectAlignmentMask ^ 0xFFFFFFFFFFFFFFFFL), NodeView.DEFAULT));
                    EndNode instanceBranch = graph.add(new EndNode());
                    ValueNode layoutHelperLong = b.add(SignExtendNode.create(layoutHelper, JavaKind.Long.getBitCount(), NodeView.DEFAULT));
                    ValueNode instanceSizeLong = b.add(AndNode.create(layoutHelperLong, ConstantNode.forLong(-((long)JavaKind.Long.getByteCount())), NodeView.DEFAULT));
                    b.add(new IfNode(isArray, arrayLengthNode, instanceBranch, ProfileData.BranchProbabilityData.injected(0.5)));
                    MergeNode merge = b.append(new MergeNode());
                    merge.addForwardEnd(arrayBranch);
                    merge.addForwardEnd(instanceBranch);
                    b.addPush(JavaKind.Long, new ValuePhiNode(StampFactory.forKind(JavaKind.Long), merge, arrayInstanceSizeMaskedLong, instanceSizeLong));
                    b.setStateAfter(merge);
                }
                return true;
            }
        });
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/cf158bc6cdadfdfa944b8ec1d3dc7069c8f055a9/src/hotspot/share/opto/library_call.cpp#L3740-L3823", sha1="f05a07a18ffae50e2a2b20586184a26e9cc8c5f2")
    private static class ContinuationPinningPlugin
    extends InvocationPlugin {
        private final GraalHotSpotVMConfig config;
        private final boolean pin;

        ContinuationPinningPlugin(GraalHotSpotVMConfig config, boolean pin) {
            super(pin ? "pin" : "unpin", new Type[0]);
            this.config = config;
            this.pin = pin;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
            try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, this.config);){
                StructuredGraph graph = b.getGraph();
                CurrentJavaThreadNode javaThread = graph.addOrUniqueWithInputs(new CurrentJavaThreadNode(helper.getWordKind()));
                GraalError.guarantee(this.config.contEntry != -1, "JavaThread::_cont_entry is not exported");
                OffsetAddressNode lastContinuationAddr = graph.addOrUniqueWithInputs(new OffsetAddressNode(javaThread, helper.asWord(this.config.contEntry)));
                ValueNode lastContinuation = b.add(new JavaReadNode(JavaKind.Object, lastContinuationAddr, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_CONT_ENTRY, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                PiNode nonNullLastContinuation = helper.emitNullReturnGuard(lastContinuation, null, 0.09999999999999998);
                GraalError.guarantee(this.config.pinCount != -1, "ContinuationEntry::_pin_count is not exported");
                OffsetAddressNode pinCountAddr = graph.addOrUniqueWithInputs(new OffsetAddressNode(nonNullLastContinuation, helper.asWord(this.config.pinCount)));
                ValueNode pinCount = b.add(new JavaReadNode(JavaKind.Int, pinCountAddr, HotSpotReplacementsUtil.HOTSPOT_CONTINUATION_ENTRY_PIN_COUNT, BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                LogicNode overFlow = IntegerEqualsNode.create(pinCount, this.pin ? ConstantNode.forInt(-1) : ConstantNode.forInt(0), NodeView.DEFAULT);
                b.append(new FixedGuardNode(overFlow, DeoptimizationReason.TypeCheckedInliningViolated, DeoptimizationAction.None, true));
                ValueNode newPinCount = b.add(AddNode.create(pinCount, this.pin ? ConstantNode.forInt(1) : ConstantNode.forInt(-1), NodeView.DEFAULT));
                b.add(new JavaWriteNode(JavaKind.Int, pinCountAddr, HotSpotReplacementsUtil.HOTSPOT_CONTINUATION_ENTRY_PIN_COUNT, newPinCount, BarrierType.NONE, false));
                helper.emitFinalReturn(JavaKind.Void, null);
            }
            return true;
        }
    }

    public static class HotSpotCipherBlockChainingCryptPlugin
    extends StandardGraphBuilderPlugins.CipherBlockChainingCryptPlugin {
        HotSpotCipherBlockChainingCryptPlugin(AESNode.CryptMode mode) {
            super(mode);
        }

        @Override
        protected boolean canApply(GraphBuilderContext b) {
            return b instanceof BytecodeParser || b instanceof IntrinsicGraphBuilder;
        }

        @Override
        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
            return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
        }
    }

    public static class ElectronicCodeBookCryptPlugin
    extends StandardGraphBuilderPlugins.AESCryptDelegatePlugin {
        ElectronicCodeBookCryptPlugin(AESNode.CryptMode mode) {
            super(mode, mode.isEncrypt() ? "implECBEncrypt" : "implECBDecrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaType typeAESCrypt = this.getTypeAESCrypt(b.getMetaAccess(), receiverType);
                ValueNode nonNullReceiver = receiver.get(true);
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readEmbeddedAESCryptKArrayStart(b, helper, receiverType, typeAESCrypt, nonNullReceiver);
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)(this.mode.isEncrypt() ? HotSpotBackend.ELECTRONIC_CODEBOOK_ENCRYPT_AESCRYPT : HotSpotBackend.ELECTRONIC_CODEBOOK_DECRYPT_AESCRYPT), inAddr, outAddr, kAddr, len);
                helper.emitFinalReturn(JavaKind.Int, call);
                boolean bl = true;
                return bl;
            }
        }

        @Override
        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
            return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
        }
    }

    public static class GaloisCounterModeCryptPlugin
    extends StandardGraphBuilderPlugins.AESCryptDelegatePlugin {
        GaloisCounterModeCryptPlugin() {
            super(AESNode.CryptMode.ENCRYPT, "implGCMCrypt0", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, new InvocationPlugins.OptionalLazySymbol("com.sun.crypto.provider.GCTR"), new InvocationPlugins.OptionalLazySymbol("com.sun.crypto.provider.GHASH")});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode ct, ValueNode ctOffset, ValueNode out, ValueNode outOffset, ValueNode gctr, ValueNode ghash) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType receiverType = targetMethod.getDeclaringClass();
                ResolvedJavaType typeAESCrypt = this.getTypeAESCrypt(b.getMetaAccess(), receiverType);
                ResolvedJavaType typeGCTR = GaloisCounterModeCryptPlugin.getTypeGCTR(receiverType);
                ResolvedJavaType typeGHASH = GaloisCounterModeCryptPlugin.getTypeGHASH(receiverType);
                ValueNode nonNullGCTR = b.nullCheckedValue(gctr);
                ValueNode nonNullGHASH = b.nullCheckedValue(ghash);
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode ctAddr = helper.arrayElementPointer(ct, JavaKind.Byte, ctOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readEmbeddedAESCryptKArrayStart(b, helper, typeGCTR, typeAESCrypt, nonNullGCTR);
                ValueNode counterAddr = GaloisCounterModeCryptPlugin.readFieldArrayStart(b, helper, typeGCTR, "counter", nonNullGCTR, JavaKind.Byte);
                ValueNode stateAddr = GaloisCounterModeCryptPlugin.readFieldArrayStart(b, helper, typeGHASH, "state", nonNullGHASH, JavaKind.Long);
                ValueNode subkeyHtblAddr = GaloisCounterModeCryptPlugin.readFieldArrayStart(b, helper, typeGHASH, "subkeyHtbl", nonNullGHASH, JavaKind.Long);
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.GALOIS_COUNTER_MODE_CRYPT, inAddr, len, ctAddr, outAddr, kAddr, stateAddr, subkeyHtblAddr, counterAddr);
                helper.emitFinalReturn(JavaKind.Int, call);
                boolean bl = true;
                return bl;
            }
        }

        private static ResolvedJavaType getTypeGCTR(ResolvedJavaType context) {
            return UnresolvedJavaType.create((String)"Lcom/sun/crypto/provider/GCTR;").resolve(context);
        }

        private static ResolvedJavaType getTypeGHASH(ResolvedJavaType context) {
            return UnresolvedJavaType.create((String)"Lcom/sun/crypto/provider/GHASH;").resolve(context);
        }

        @Override
        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) {
            return HotSpotGraphBuilderPlugins.resolveTypeAESCrypt(context);
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> ForceExplicitReachabilityFence = new OptionKey<Boolean>(false);
    }
}

