/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.word.LocationIdentity;

public class HotSpotForeignCallDescriptor
extends ForeignCallDescriptor {
    private final Transition transition;

    public HotSpotForeignCallDescriptor(Transition transition, ForeignCallDescriptor.CallSideEffect callSideEffect, LocationIdentity[] killedLocations, String name, Class<?> resultType, Class<?> ... argumentTypes) {
        super(name, resultType, argumentTypes, callSideEffect, killedLocations, transition == Transition.SAFEPOINT, transition == Transition.SAFEPOINT);
        this.transition = transition;
    }

    public HotSpotForeignCallDescriptor(Transition transition, ForeignCallDescriptor.CallSideEffect callSideEffect, LocationIdentity killedLocation, String name, Class<?> resultType, Class<?> ... argumentTypes) {
        LocationIdentity[] locationIdentityArray;
        if (killedLocation == null) {
            locationIdentityArray = HotSpotForeignCallsProviderImpl.NO_LOCATIONS;
        } else {
            LocationIdentity[] locationIdentityArray2 = new LocationIdentity[1];
            locationIdentityArray = locationIdentityArray2;
            locationIdentityArray2[0] = killedLocation;
        }
        this(transition, callSideEffect, locationIdentityArray, name, resultType, argumentTypes);
    }

    public HotSpotForeignCallDescriptor(ForeignCallSignature signature, Transition transition, ForeignCallDescriptor.CallSideEffect callSideEffect, LocationIdentity[] killedLocations) {
        this(transition, callSideEffect, killedLocations, signature.getName(), signature.getResultType(), signature.getArgumentTypes());
    }

    public Transition getTransition() {
        return this.transition;
    }

    public ForeignCallDescriptor.CallSideEffect getCallSideEffect() {
        return this.callSideEffect;
    }

    @Override
    public String toString() {
        return "HotSpotForeignCallDescriptor{" + String.valueOf(this.signature) + ", callSideEffect=" + String.valueOf((Object)this.callSideEffect) + ", canDeoptimize=" + this.canDeoptimize + ", isGuaranteedSafepoint=" + this.isGuaranteedSafepoint + ", killedLocations=" + Arrays.toString(this.killedLocations) + ", transition=" + String.valueOf((Object)this.transition) + "}";
    }

    public static enum Transition {
        LEAF_NO_VZERO,
        LEAF,
        STACK_INSPECTABLE_LEAF,
        SAFEPOINT;

    }
}

