/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotSuitesProvider;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Speculative;
import jdk.graal.compiler.phases.common.AddressLoweringPhase;
import jdk.graal.compiler.phases.common.TransplantGraphsPhase;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.tiers.SuitesCreator;
import jdk.vm.ci.code.Architecture;

public class AddressLoweringHotSpotSuitesProvider
extends HotSpotSuitesProvider {
    private final BasePhase<CoreProviders> addressLowering;

    public AddressLoweringHotSpotSuitesProvider(SuitesCreator defaultSuitesCreator, GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, BasePhase<CoreProviders> addressLowering) {
        super(defaultSuitesCreator, config, runtime);
        this.addressLowering = addressLowering;
    }

    @Override
    public Suites createSuites(OptionValues options, Architecture arch) {
        Suites suites = super.createSuites(options, arch);
        suites.getLowTier().replacePlaceholder(AddressLoweringPhase.class, this.addressLowering);
        suites.getLowTier().replacePlaceholder(TransplantGraphsPhase.class, new TransplantGraphsPhase(AddressLoweringHotSpotSuitesProvider.createSuitesForLateSnippetTemplate(suites)));
        return suites;
    }

    private static Suites createSuitesForLateSnippetTemplate(Suites regularCompileSuites) {
        Suites s = regularCompileSuites.copy();
        s.getHighTier().removeSubTypePhases(Speculative.class);
        s.getMidTier().removeSubTypePhases(Speculative.class);
        s.getLowTier().removeSubTypePhases(Speculative.class);
        s.getLowTier().removeAllPlaceHolderOfType(TransplantGraphsPhase.class);
        return s;
    }
}

