/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.serviceprovider.IsolateUtil;
import jdk.graal.compiler.serviceprovider.ServiceProvider;
import jdk.vm.ci.hotspot.HotSpotVMEventListener;
import jdk.vm.ci.services.JVMCIServiceLocator;

@ServiceProvider(value=JVMCIServiceLocator.class)
public class TruffleLibGraalShutdownHook
extends JVMCIServiceLocator {
    private static volatile ShutdownHook registeredHook;

    protected <S> S getProvider(Class<S> service) {
        ShutdownHook hook = registeredHook;
        if (hook != null && service == HotSpotVMEventListener.class) {
            return service.cast(hook);
        }
        return null;
    }

    static void registerShutdownHook() {
        registeredHook = new ShutdownHook();
    }

    static class ShutdownHook
    implements HotSpotVMEventListener {
        private static final Handles HANDLES = new Handles();

        ShutdownHook() {
        }

        public void notifyShutdown() {
            try {
                ShutdownHook.HANDLES.onIsolateShutdown.invoke(IsolateUtil.getIsolateID());
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private static final class Handles {
        final MethodHandle onIsolateShutdown = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnIsolateShutdown);

        private Handles() {
        }
    }
}

