/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import java.lang.invoke.MethodHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;

final class NativeImageHostCalls {
    private static final Handles HANDLES = new Handles();

    private NativeImageHostCalls() {
    }

    static void initializeHost(long runtimeClass) {
        try {
            NativeImageHostCalls.HANDLES.initializeHost.invoke(runtimeClass);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static Object createLocalHandleForLocalReference(long jniLocalHandle) {
        try {
            return NativeImageHostCalls.HANDLES.createLocalHandleForLocalReference.invoke(jniLocalHandle);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static Object createLocalHandleForWeakGlobalReference(long jniLocalHandle) {
        try {
            return NativeImageHostCalls.HANDLES.createLocalHandleForWeakGlobalReference.invoke(jniLocalHandle);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static Object createGlobalHandle(Object hsHandle, boolean allowGlobalDuplicates) {
        try {
            return NativeImageHostCalls.HANDLES.createGlobalHandle.invoke(hsHandle, allowGlobalDuplicates);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static boolean isSameObject(Object o1, Object o2) {
        try {
            return NativeImageHostCalls.HANDLES.isSameObject.invoke(o1, o2);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static long getObjectClass(Object o) {
        try {
            return NativeImageHostCalls.HANDLES.getObjectClass.invoke(o);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static Object createTruffleCompilerOptionDescriptor(String name, int type, boolean deprecated, String help, String deprecationMessage) {
        try {
            return NativeImageHostCalls.HANDLES.createTruffleCompilerOptionDescriptor.invoke(name, type, deprecated, help, deprecationMessage);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    static void onCompilationSuccess(Object hsHandle, int compilationTier, boolean lastTier) {
        try {
            NativeImageHostCalls.HANDLES.onCompilationSuccess.invoke(hsHandle, compilationTier, lastTier);
        }
        catch (Throwable t) {
            throw HSIndirectHandle.handleException(t);
        }
    }

    private static final class Handles {
        final MethodHandle initializeHost = BuildTime.getHostMethodHandleOrFail("initializeHost");
        final MethodHandle createLocalHandleForLocalReference = BuildTime.getHostMethodHandleOrFail("createLocalHandleForLocalReference");
        final MethodHandle createLocalHandleForWeakGlobalReference = BuildTime.getHostMethodHandleOrFail("createLocalHandleForWeakGlobalReference");
        final MethodHandle createGlobalHandle = BuildTime.getHostMethodHandleOrFail("createGlobalHandle");
        final MethodHandle isSameObject = BuildTime.getHostMethodHandleOrFail("isSameObject");
        final MethodHandle getObjectClass = BuildTime.getHostMethodHandleOrFail("getObjectClass");
        final MethodHandle createTruffleCompilerOptionDescriptor = BuildTime.getHostMethodHandleOrFail("createTruffleCompilerOptionDescriptor");
        final MethodHandle onCompilationSuccess = BuildTime.getHostMethodHandleOrFail("onCompilationSuccess");

        private Handles() {
        }
    }
}

