/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilerRuntime;
import jdk.graal.compiler.hotspot.libgraal.truffle.LibGraalTruffleHostEnvironment;
import jdk.graal.compiler.hotspot.libgraal.truffle.NativeImageHostCalls;
import jdk.graal.compiler.serviceprovider.GlobalAtomicLong;
import jdk.graal.compiler.truffle.host.TruffleHostEnvironment;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class LibGraalTruffleHostEnvironmentLookup
implements TruffleHostEnvironment.Lookup {
    private static final int NO_TRUFFLE_REGISTERED = 0;
    private static final GlobalAtomicLong WEAK_TRUFFLE_RUNTIME_INSTANCE = new GlobalAtomicLong(0L);
    @NativeImageReinitialize
    private TruffleHostEnvironment previousRuntime;

    @Override
    public TruffleHostEnvironment lookup(ResolvedJavaType forType) {
        Object cached;
        long globalReference = WEAK_TRUFFLE_RUNTIME_INSTANCE.get();
        if (globalReference == 0L) {
            return null;
        }
        Object runtimeLocalHandle = NativeImageHostCalls.createLocalHandleForWeakGlobalReference(globalReference);
        if (runtimeLocalHandle == null) {
            return null;
        }
        TruffleHostEnvironment environment = this.previousRuntime;
        if (environment != null && NativeImageHostCalls.isSameObject(cached = LibGraalTruffleHostEnvironmentLookup.hsRuntime((TruffleHostEnvironment)environment).hsHandle, runtimeLocalHandle)) {
            return environment;
        }
        try (TruffleHostEnvironment.TruffleRuntimeScope scope = LibGraalTruffleHostEnvironment.openTruffleRuntimeScopeImpl();){
            HSTruffleCompilerRuntime runtime = new HSTruffleCompilerRuntime(NativeImageHostCalls.createGlobalHandle(runtimeLocalHandle, true), NativeImageHostCalls.getObjectClass(runtimeLocalHandle));
            this.previousRuntime = environment = new LibGraalTruffleHostEnvironment(runtime, HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess());
            TruffleHostEnvironment truffleHostEnvironment = environment;
            return truffleHostEnvironment;
        }
    }

    private static HSTruffleCompilerRuntime hsRuntime(TruffleHostEnvironment environment) {
        return (HSTruffleCompilerRuntime)environment.runtime();
    }

    static boolean registerRuntime(long truffleRuntimeWeakRef) {
        return WEAK_TRUFFLE_RUNTIME_INSTANCE.compareAndSet(0L, truffleRuntimeWeakRef);
    }
}

