/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import jdk.graal.compiler.core.common.util.MethodKey;
import jdk.graal.compiler.hotspot.CompilationContext;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.truffle.TruffleCompilerImpl;
import jdk.graal.compiler.truffle.TruffleElementCache;
import jdk.graal.compiler.truffle.host.TruffleHostEnvironment;
import jdk.graal.compiler.truffle.host.TruffleKnownHostTypes;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleCompilerImpl;
import jdk.vm.ci.meta.AnnotationData;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

final class LibGraalTruffleHostEnvironment
extends TruffleHostEnvironment {
    private final HostMethodInfoCache hostCache = new HostMethodInfoCache();

    LibGraalTruffleHostEnvironment(TruffleCompilerRuntime runtime, MetaAccessProvider metaAccess) {
        super(runtime, metaAccess);
    }

    @Override
    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod method) {
        return (HostMethodInfo)this.hostCache.get(method);
    }

    @Override
    protected TruffleCompilerImpl createCompiler(TruffleCompilable ast) {
        try (CompilationContext compilationContext = HotSpotGraalServices.enterGlobalCompilationContext();){
            HotSpotTruffleCompilerImpl compiler = HotSpotTruffleCompilerImpl.create(this.runtime(), LibGraalTruffleHostEnvironment::openTruffleRuntimeScopeImpl);
            compiler.initialize(ast, true);
            HotSpotTruffleCompilerImpl hotSpotTruffleCompilerImpl = compiler;
            return hotSpotTruffleCompilerImpl;
        }
    }

    @Override
    public TruffleHostEnvironment.TruffleRuntimeScope openTruffleRuntimeScope() {
        return LibGraalTruffleHostEnvironment.openTruffleRuntimeScopeImpl();
    }

    static TruffleHostEnvironment.TruffleRuntimeScope openTruffleRuntimeScopeImpl() {
        return TruffleRuntimeScopeImpl.CAN_CALL_JAVA_SCOPE != null ? new TruffleRuntimeScopeImpl() : null;
    }

    final class HostMethodInfoCache
    extends TruffleElementCache<ResolvedJavaMethod, HostMethodInfo> {
        HostMethodInfoCache() {
            super(4096);
        }

        @Override
        protected Object createKey(ResolvedJavaMethod method) {
            return new MethodKey(method);
        }

        @Override
        protected HostMethodInfo computeValue(ResolvedJavaMethod method) {
            TruffleKnownHostTypes hostTypes = LibGraalTruffleHostEnvironment.this.types();
            List annotationDataList = method.getAnnotationData(hostTypes.TruffleBoundary, hostTypes.BytecodeInterpreterSwitch, new ResolvedJavaType[]{hostTypes.BytecodeInterpreterSwitchBoundary, hostTypes.InliningCutoff});
            boolean isTruffleBoundary = false;
            boolean isBytecodeInterpreterSwitch = false;
            boolean isBytecodeInterpreterSwitchBoundary = false;
            boolean isInliningCutoff = false;
            for (AnnotationData annotationData : annotationDataList) {
                String annotationTypeFqn = annotationData.getAnnotationType().getName();
                if (hostTypes.TruffleBoundary.getName().equals(annotationTypeFqn)) {
                    isTruffleBoundary = true;
                    continue;
                }
                if (hostTypes.BytecodeInterpreterSwitch.getName().equals(annotationTypeFqn)) {
                    isBytecodeInterpreterSwitch = true;
                    continue;
                }
                if (hostTypes.BytecodeInterpreterSwitchBoundary.getName().equals(annotationTypeFqn)) {
                    isBytecodeInterpreterSwitchBoundary = true;
                    continue;
                }
                if (!hostTypes.InliningCutoff.getName().equals(annotationTypeFqn)) continue;
                isInliningCutoff = true;
            }
            return new HostMethodInfo(isTruffleBoundary, isBytecodeInterpreterSwitch, isBytecodeInterpreterSwitchBoundary, isInliningCutoff);
        }
    }

    private static final class TruffleRuntimeScopeImpl
    implements TruffleHostEnvironment.TruffleRuntimeScope {
        private static final MethodHandle CAN_CALL_JAVA_SCOPE = TruffleRuntimeScopeImpl.findCompilerThreadCanCallJavaScopeConstructor();
        private final AutoCloseable impl;

        private static MethodHandle findCompilerThreadCanCallJavaScopeConstructor() {
            try {
                return MethodHandles.lookup().findConstructor(Class.forName("jdk.vm.ci.hotspot.CompilerThreadCanCallJavaScope"), MethodType.methodType(Void.TYPE, Boolean.TYPE));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return null;
            }
        }

        TruffleRuntimeScopeImpl() {
            try {
                this.impl = CAN_CALL_JAVA_SCOPE.invoke(true);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }

        @Override
        public void close() {
            try {
                this.impl.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

