/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.TruffleSourceLanguagePosition;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;

final class HSTruffleSourceLanguagePosition
extends HSIndirectHandle
implements TruffleSourceLanguagePosition {
    private static final Handles HANDLES = new Handles();

    HSTruffleSourceLanguagePosition(Object hsHandle) {
        super(hsHandle);
    }

    public String getDescription() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getDescription.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    public int getOffsetEnd() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getOffsetEnd.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    public int getOffsetStart() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getOffsetStart.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    public int getLineNumber() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getLineNumber.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    public URI getURI() {
        String uri;
        try {
            uri = HSTruffleSourceLanguagePosition.HANDLES.getURI.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
        return uri == null ? null : URI.create(uri);
    }

    public String getLanguage() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getLanguage.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    public int getNodeId() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getNodeId.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    public String getNodeClassName() {
        try {
            return HSTruffleSourceLanguagePosition.HANDLES.getNodeClassName.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleSourceLanguagePosition.handleException(t);
        }
    }

    private static final class Handles {
        final MethodHandle getOffsetStart = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetOffsetStart);
        final MethodHandle getOffsetEnd = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetOffsetEnd);
        final MethodHandle getLineNumber = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetLineNumber);
        final MethodHandle getLanguage = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetLanguage);
        final MethodHandle getDescription = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetDescription);
        final MethodHandle getURI = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetURI);
        final MethodHandle getNodeClassName = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetNodeClassName);
        final MethodHandle getNodeId = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetNodeId);

        private Handles() {
        }
    }
}

