/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.ConstantFieldInfo;
import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSConsumer;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilable;
import jdk.graal.compiler.hotspot.libgraal.truffle.NativeImageHostCalls;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleCompilationSupport;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;

final class HSTruffleCompilerRuntime
extends HSIndirectHandle
implements TruffleCompilerRuntime {
    private static final Handles HANDLES;
    static final String COMPILER_VERSION;
    private static final Class<?> TRANSLATED_EXCEPTION;
    private final ResolvedJavaType classLoaderDelegate;

    HSTruffleCompilerRuntime(Object hsHandle, long runtimeClass) {
        super(hsHandle);
        this.classLoaderDelegate = HotSpotJVMCIRuntime.runtime().asResolvedJavaType(runtimeClass);
        if (this.classLoaderDelegate == null) {
            throw GraalError.shouldNotReachHere("The object class needs to be available for a Truffle runtime object.");
        }
        NativeImageHostCalls.initializeHost(runtimeClass);
    }

    public PartialEvaluationMethodInfo getPartialEvaluationMethodInfo(ResolvedJavaMethod method) {
        byte[] array;
        long methodHandle = HotSpotJVMCIRuntime.runtime().translate((Object)method);
        try {
            array = HSTruffleCompilerRuntime.HANDLES.getPartialEvaluationMethodInfo.invoke(this.hsHandle, methodHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
        TruffleCompilerRuntime.LoopExplosionKind loopExplosionKind = TruffleCompilerRuntime.LoopExplosionKind.values()[array[0]];
        TruffleCompilerRuntime.InlineKind peInlineKind = TruffleCompilerRuntime.InlineKind.values()[array[1]];
        TruffleCompilerRuntime.InlineKind inlineKind = TruffleCompilerRuntime.InlineKind.values()[array[2]];
        boolean inlineable = array[3] != 0;
        boolean isSpecializationMethod = array[4] != 0;
        return new PartialEvaluationMethodInfo(loopExplosionKind, peInlineKind, inlineKind, inlineable, isSpecializationMethod);
    }

    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod method) {
        throw new UnsupportedOperationException("Use TruffleHostEnvironment#getHostMethodInfo()");
    }

    public TruffleCompilable asCompilableTruffleAST(JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        long jniLocalRef = HotSpotJVMCIRuntime.runtime().getJObjectValue((HotSpotObjectConstant)constant);
        Object compilableHsHandle = NativeImageHostCalls.createLocalHandleForLocalReference(jniLocalRef);
        return compilableHsHandle == null ? null : new HSTruffleCompilable(compilableHsHandle);
    }

    public void onCodeInstallation(TruffleCompilable compilable, InstalledCode installedCode) {
        long installedCodeHandle = HotSpotJVMCIRuntime.runtime().translate((Object)installedCode);
        try {
            HSTruffleCompilerRuntime.HANDLES.onCodeInstallation.invoke(this.hsHandle, ((HSTruffleCompilable)compilable).hsHandle, installedCodeHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
    }

    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumption) {
        Object hsDependencyHandle;
        long optimizedAssumptionHandle = HotSpotJVMCIRuntime.runtime().translate((Object)optimizedAssumption);
        try {
            hsDependencyHandle = HSTruffleCompilerRuntime.HANDLES.registerOptimizedAssumptionDependency.invoke(this.hsHandle, optimizedAssumptionHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
        return hsDependencyHandle == null ? null : new HSConsumer(hsDependencyHandle);
    }

    public boolean isValueType(ResolvedJavaType type) {
        long typeHandle = HotSpotJVMCIRuntime.runtime().translate((Object)type);
        try {
            return HSTruffleCompilerRuntime.HANDLES.isValueType.invoke(this.hsHandle, typeHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
    }

    public ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        int rawValue;
        ResolvedJavaType enclosingType = field.getDeclaringClass();
        boolean isStatic = field.isStatic();
        Object[] declaredFields = isStatic ? enclosingType.getStaticFields() : enclosingType.getInstanceFields(false);
        int fieldIndex = -1;
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!field.equals((Object)declaredFields[i])) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex == -1) {
            throw new IllegalStateException(String.format("%s field: %s declared in: %s is not in declared fields: %s", isStatic ? "Static" : "Instance", field, enclosingType, Arrays.toString(declaredFields)));
        }
        long typeHandle = HotSpotJVMCIRuntime.runtime().translate((Object)enclosingType);
        try {
            rawValue = HSTruffleCompilerRuntime.HANDLES.getConstantFieldInfo.invoke(this.hsHandle, typeHandle, isStatic, fieldIndex);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
        return switch (rawValue) {
            case Integer.MIN_VALUE -> null;
            case -1 -> ConstantFieldInfo.CHILD;
            case -2 -> ConstantFieldInfo.CHILDREN;
            default -> ConstantFieldInfo.forDimensions((int)rawValue);
        };
    }

    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        JavaType jt;
        String internalName = HSTruffleCompilerRuntime.getInternalName(className);
        try {
            jt = HotSpotJVMCIRuntime.runtime().lookupType(internalName, (HotSpotResolvedObjectType)this.classLoaderDelegate, required);
        }
        catch (Exception e) {
            if (TRANSLATED_EXCEPTION != null && TRANSLATED_EXCEPTION.isInstance(e)) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
            }
            throw e;
        }
        if (jt instanceof UnresolvedJavaType) {
            if (required) {
                throw new NoClassDefFoundError(internalName);
            }
            return null;
        }
        ResolvedJavaType resolvedType = (ResolvedJavaType)jt;
        resolvedType.link();
        return resolvedType;
    }

    private static String getInternalName(String fqn) {
        return "L" + fqn.replace('.', '/') + ";";
    }

    public void log(String loggerId, TruffleCompilable compilable, String message) {
        try {
            HSTruffleCompilerRuntime.HANDLES.log.invoke(this.hsHandle, loggerId, ((HSTruffleCompilable)compilable).hsHandle, message);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
    }

    public boolean isSuppressedFailure(TruffleCompilable compilable, Supplier<String> serializedException) {
        try {
            Object supplierHsHandle = HSTruffleCompilerRuntime.HANDLES.createStringSupplier.invoke(serializedException);
            return HSTruffleCompilerRuntime.HANDLES.isSuppressedFailure.invoke(this.hsHandle, ((HSTruffleCompilable)compilable).hsHandle, supplierHsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerRuntime.handleException(t);
        }
    }

    static {
        Class<?> clz;
        HANDLES = new Handles();
        COMPILER_VERSION = HotSpotTruffleCompilationSupport.readCompilerVersion();
        try {
            clz = Class.forName("jdk.internal.vm.TranslatedException");
        }
        catch (ClassNotFoundException cnf) {
            clz = null;
        }
        TRANSLATED_EXCEPTION = clz;
    }

    private static final class Handles {
        final MethodHandle getPartialEvaluationMethodInfo = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetPartialEvaluationMethodInfo);
        final MethodHandle onCodeInstallation = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnCodeInstallation);
        final MethodHandle registerOptimizedAssumptionDependency = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.RegisterOptimizedAssumptionDependency);
        final MethodHandle isValueType = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.IsValueType);
        final MethodHandle getConstantFieldInfo = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetConstantFieldInfo);
        final MethodHandle log = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.Log);
        final MethodHandle createStringSupplier = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.CreateStringSupplier);
        final MethodHandle isSuppressedFailure = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.IsSuppressedFailure);

        private Handles() {
        }
    }
}

