/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.util.function.Supplier;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilable;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilationTask;

final class HSTruffleCompilerListener
extends HSIndirectHandle
implements TruffleCompilerListener {
    private static final Handles HANDLES = new Handles();

    HSTruffleCompilerListener(Object hsHandle) {
        super(hsHandle);
    }

    public void onSuccess(TruffleCompilable compilable, TruffleCompilationTask task, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo, int tier) {
        Object hsCompilable = ((HSTruffleCompilable)compilable).hsHandle;
        Object hsTask = ((HSTruffleCompilationTask)task).hsHandle;
        try {
            HSTruffleCompilerListener.HANDLES.onSuccess.invoke(this.hsHandle, hsCompilable, hsTask, graphInfo, compilationResultInfo, tier);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerListener.handleException(t);
        }
    }

    public void onTruffleTierFinished(TruffleCompilable compilable, TruffleCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
        Object hsCompilable = ((HSTruffleCompilable)compilable).hsHandle;
        Object hsTask = ((HSTruffleCompilationTask)task).hsHandle;
        try {
            HSTruffleCompilerListener.HANDLES.onTruffleTierFinished.invoke(this.hsHandle, hsCompilable, hsTask, graph);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerListener.handleException(t);
        }
    }

    public void onGraalTierFinished(TruffleCompilable compilable, TruffleCompilerListener.GraphInfo graph) {
        Object hsCompilable = ((HSTruffleCompilable)compilable).hsHandle;
        try {
            HSTruffleCompilerListener.HANDLES.onGraalTierFinished.invoke(this.hsHandle, hsCompilable, graph);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerListener.handleException(t);
        }
    }

    public void onFailure(TruffleCompilable compilable, String reason, boolean bailout, boolean permanentBailout, int tier, Supplier<String> lazyStackTrace) {
        Object hsCompilable = ((HSTruffleCompilable)compilable).hsHandle;
        try {
            HSTruffleCompilerListener.HANDLES.onFailure.invoke(this.hsHandle, hsCompilable, reason, bailout, permanentBailout, tier, lazyStackTrace);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerListener.handleException(t);
        }
    }

    public void onCompilationRetry(TruffleCompilable compilable, TruffleCompilationTask task) {
        Object hsCompilable = ((HSTruffleCompilable)compilable).hsHandle;
        Object hsTask = ((HSTruffleCompilationTask)task).hsHandle;
        try {
            HSTruffleCompilerListener.HANDLES.onCompilationRetry.invoke(this.hsHandle, hsCompilable, hsTask);
        }
        catch (Throwable t) {
            throw HSTruffleCompilerListener.handleException(t);
        }
    }

    private static final class Handles {
        final MethodHandle onSuccess = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnSuccess);
        final MethodHandle onTruffleTierFinished = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnTruffleTierFinished);
        final MethodHandle onGraalTierFinished = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnGraalTierFinished);
        final MethodHandle onFailure = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnFailure);
        final MethodHandle onCompilationRetry = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnCompilationRetry);

        private Handles() {
        }
    }
}

