/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleSourceLanguagePosition;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilable;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleSourceLanguagePosition;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaConstant;

final class HSTruffleCompilationTask
extends HSIndirectHandle
implements TruffleCompilationTask {
    private static final Handles HANDLES = new Handles();

    HSTruffleCompilationTask(Object hsHandle) {
        super(hsHandle);
    }

    public boolean isCancelled() {
        try {
            return HSTruffleCompilationTask.HANDLES.isCancelled.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    public boolean isLastTier() {
        try {
            return HSTruffleCompilationTask.HANDLES.isLastTier.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    public boolean hasNextTier() {
        try {
            return HSTruffleCompilationTask.HANDLES.hasNextTier.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    public TruffleSourceLanguagePosition getPosition(JavaConstant node) {
        Object positionHsHandle;
        long nodeHandle = HotSpotJVMCIRuntime.runtime().translate((Object)node);
        try {
            positionHsHandle = HSTruffleCompilationTask.HANDLES.getPosition.invoke(this.hsHandle, nodeHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
        if (positionHsHandle == null) {
            return null;
        }
        return new HSTruffleSourceLanguagePosition(positionHsHandle);
    }

    public void addTargetToDequeue(TruffleCompilable target) {
        try {
            HSTruffleCompilationTask.HANDLES.addTargetToDequeue.invoke(this.hsHandle, ((HSTruffleCompilable)target).hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    public void setCallCounts(int total, int inlined) {
        try {
            HSTruffleCompilationTask.HANDLES.setCallCounts.invoke(this.hsHandle, total, inlined);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    public void addInlinedTarget(TruffleCompilable target) {
        try {
            HSTruffleCompilationTask.HANDLES.addInlinedTarget.invoke(this.hsHandle, ((HSTruffleCompilable)target).hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    public Map<String, Object> getDebugProperties(JavaConstant node) {
        try {
            long nodeHandle = HotSpotJVMCIRuntime.runtime().translate((Object)node);
            return HSTruffleCompilationTask.HANDLES.getDebugProperties.invoke(this.hsHandle, nodeHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilationTask.handleException(t);
        }
    }

    private static final class Handles {
        final MethodHandle isCancelled = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.IsCancelled);
        final MethodHandle hasNextTier = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.HasNextTier);
        final MethodHandle isLastTier = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.IsLastTier);
        final MethodHandle getPosition = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetPosition);
        final MethodHandle addTargetToDequeue = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.AddTargetToDequeue);
        final MethodHandle setCallCounts = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.SetCallCounts);
        final MethodHandle addInlinedTarget = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.AddInlinedTarget);
        final MethodHandle getDebugProperties = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetDebugProperties);

        private Handles() {
        }
    }
}

