/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.NativeImageHostCalls;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;

final class HSTruffleCompilable
extends HSIndirectHandle
implements TruffleCompilable {
    private static final Handles HANDLES = new Handles();
    private Long cachedFailedSpeculationsAddress;
    private volatile String cachedName;
    private volatile String cachedString;

    HSTruffleCompilable(Object hsHandle) {
        super(hsHandle);
    }

    public SpeculationLog getCompilationSpeculationLog() {
        Long res = this.cachedFailedSpeculationsAddress;
        if (res == null) {
            try {
                this.cachedFailedSpeculationsAddress = res = Long.valueOf(HSTruffleCompilable.HANDLES.getFailedSpeculationsAddress.invoke(this.hsHandle));
            }
            catch (Throwable t) {
                throw HSTruffleCompilable.handleException(t);
            }
        }
        return HotSpotGraalServices.newHotSpotSpeculationLog(this.cachedFailedSpeculationsAddress);
    }

    public Map<String, String> getCompilerOptions() {
        try {
            return HSTruffleCompilable.HANDLES.getCompilerOptions.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public long engineId() {
        try {
            return HSTruffleCompilable.HANDLES.engineId.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public boolean prepareForCompilation(boolean rootCompilation, int compilationTier, boolean lastTier) {
        try {
            return HSTruffleCompilable.HANDLES.prepareForCompilation.invoke(this.hsHandle, rootCompilation, compilationTier, lastTier);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public boolean isTrivial() {
        try {
            return HSTruffleCompilable.HANDLES.isTrivial.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public JavaConstant asJavaConstant() {
        long constantHandle;
        try {
            constantHandle = HSTruffleCompilable.HANDLES.asJavaConstant.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
        return (JavaConstant)HotSpotJVMCIRuntime.runtime().unhand(JavaConstant.class, constantHandle);
    }

    public void onCompilationFailed(Supplier<String> serializedException, boolean suppressed, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        try {
            Object serializedExceptionHsHandle = HSTruffleCompilable.HANDLES.createStringSupplier.invoke(serializedException);
            HSTruffleCompilable.HANDLES.onCompilationFailed.invoke(this.hsHandle, serializedExceptionHsHandle, suppressed, bailout, permanentBailout, graphTooBig);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public void onCompilationSuccess(int compilationTier, boolean lastTier) {
        NativeImageHostCalls.onCompilationSuccess(this.hsHandle, compilationTier, lastTier);
    }

    public boolean onInvalidate(Object source, CharSequence reason, boolean wasActive) {
        throw GraalError.shouldNotReachHere("Should not be reachable.");
    }

    public String getName() {
        String res = this.cachedName;
        if (res == null) {
            try {
                this.cachedName = res = HSTruffleCompilable.HANDLES.getCompilableName.invoke(this.hsHandle);
            }
            catch (Throwable t) {
                throw HSTruffleCompilable.handleException(t);
            }
        }
        return res;
    }

    public String toString() {
        String res = this.cachedString;
        if (res == null) {
            try {
                this.cachedString = res = HSTruffleCompilable.HANDLES.compilableToString.invoke(this.hsHandle);
            }
            catch (Throwable t) {
                throw HSTruffleCompilable.handleException(t);
            }
        }
        return res;
    }

    public int getNonTrivialNodeCount() {
        try {
            return HSTruffleCompilable.HANDLES.getNonTrivialNodeCount.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public int countDirectCallNodes() {
        try {
            return HSTruffleCompilable.HANDLES.countDirectCallNodes.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public int getCallCount() {
        try {
            return HSTruffleCompilable.HANDLES.getCompilableCallCount.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public boolean cancelCompilation(CharSequence reason) {
        try {
            return HSTruffleCompilable.HANDLES.cancelCompilation.invoke(this.hsHandle, reason);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public boolean isSameOrSplit(TruffleCompilable ast) {
        try {
            return HSTruffleCompilable.HANDLES.isSameOrSplit.invoke(this.hsHandle, ast == null ? null : ((HSTruffleCompilable)ast).hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    public int getKnownCallSiteCount() {
        try {
            return HSTruffleCompilable.HANDLES.getKnownCallSiteCount.invoke(this.hsHandle);
        }
        catch (Throwable t) {
            throw HSTruffleCompilable.handleException(t);
        }
    }

    private static final class Handles {
        final MethodHandle getFailedSpeculationsAddress = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetFailedSpeculationsAddress);
        final MethodHandle getCompilerOptions = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetCompilerOptions);
        final MethodHandle engineId = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.EngineId);
        final MethodHandle prepareForCompilation = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.PrepareForCompilation);
        final MethodHandle isTrivial = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.IsTrivial);
        final MethodHandle asJavaConstant = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.AsJavaConstant);
        final MethodHandle getCompilableName = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetCompilableName);
        final MethodHandle createStringSupplier = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.CreateStringSupplier);
        final MethodHandle onCompilationFailed = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.OnCompilationFailed);
        final MethodHandle getNonTrivialNodeCount = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetNonTrivialNodeCount);
        final MethodHandle countDirectCallNodes = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.CountDirectCallNodes);
        final MethodHandle getCompilableCallCount = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetCompilableCallCount);
        final MethodHandle compilableToString = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.CompilableToString);
        final MethodHandle cancelCompilation = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.CancelCompilation);
        final MethodHandle isSameOrSplit = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.IsSameOrSplit);
        final MethodHandle getKnownCallSiteCount = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.GetKnownCallSiteCount);

        private Handles() {
        }
    }
}

