/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerAssumptionDependency;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.util.function.Consumer;
import jdk.graal.compiler.hotspot.libgraal.truffle.BuildTime;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSIndirectHandle;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilable;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;

final class HSConsumer
extends HSIndirectHandle
implements Consumer<OptimizedAssumptionDependency> {
    private static final Handles HANDLES = new Handles();

    HSConsumer(Object hsHandle) {
        super(hsHandle);
    }

    @Override
    public void accept(OptimizedAssumptionDependency optimizedDependency) {
        long installedCode;
        Object compilableHsHandle;
        TruffleCompilerAssumptionDependency dependency = (TruffleCompilerAssumptionDependency)optimizedDependency;
        if (dependency == null) {
            compilableHsHandle = null;
            installedCode = 0L;
        } else {
            TruffleCompilable ast = dependency.getCompilable();
            compilableHsHandle = ast == null ? null : ((HSTruffleCompilable)dependency.getCompilable()).hsHandle;
            installedCode = HotSpotJVMCIRuntime.runtime().translate((Object)dependency.getInstalledCode());
        }
        try {
            HSConsumer.HANDLES.consumeOptimizedAssumptionDependency.invoke(this.hsHandle, compilableHsHandle, installedCode);
        }
        catch (Throwable t) {
            throw HSConsumer.handleException(t);
        }
    }

    private static final class Handles {
        final MethodHandle consumeOptimizedAssumptionDependency = BuildTime.getHostMethodHandleOrFail(TruffleFromLibGraal.Id.ConsumeOptimizedAssumptionDependency);

        private Handles() {
        }
    }
}

