/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.compiler.TruffleCompilerOptionDescriptor;
import java.util.function.Supplier;
import jdk.graal.compiler.hotspot.CompilationContext;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilable;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilationTask;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilerListener;
import jdk.graal.compiler.hotspot.libgraal.truffle.HSTruffleCompilerRuntime;
import jdk.graal.compiler.hotspot.libgraal.truffle.LibGraalTruffleHostEnvironmentLookup;
import jdk.graal.compiler.hotspot.libgraal.truffle.NativeImageHostCalls;
import jdk.graal.compiler.hotspot.libgraal.truffle.TruffleLibGraalShutdownHook;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleCompilationSupport;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleCompilerImpl;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class GraalEntryPoints {
    private GraalEntryPoints() {
    }

    public static void initializeIsolate() {
        TruffleLibGraalShutdownHook.registerShutdownHook();
    }

    public static boolean registerRuntime(long truffleRuntimeWeakRef) {
        return LibGraalTruffleHostEnvironmentLookup.registerRuntime(truffleRuntimeWeakRef);
    }

    public static Object initializeRuntime(Object hsHandle, long hsClassLoaderDelegate) {
        return new HSTruffleCompilerRuntime(hsHandle, hsClassLoaderDelegate);
    }

    public static Object newCompiler(Object truffleCompilerRuntime) {
        return HotSpotTruffleCompilerImpl.create((HSTruffleCompilerRuntime)truffleCompilerRuntime, null);
    }

    public static void initializeCompiler(Object compiler, Object compilableHsHandle, boolean firstInitialization) {
        HotSpotTruffleCompilerImpl truffleCompiler = (HotSpotTruffleCompilerImpl)compiler;
        HSTruffleCompilable compilable = new HSTruffleCompilable(compilableHsHandle);
        truffleCompiler.initialize(compilable, firstInitialization);
    }

    public static String getCompilerConfigurationFactoryName() {
        return HotSpotTruffleCompilationSupport.getLazyCompilerConfigurationName();
    }

    public static void doCompile(Object compiler, Object taskHsHandle, Object compilableHsHandle, Object listenerHsHandle) {
        HotSpotTruffleCompilerImpl truffleCompiler = (HotSpotTruffleCompilerImpl)compiler;
        HSTruffleCompilationTask task = taskHsHandle == null ? null : new HSTruffleCompilationTask(taskHsHandle);
        HSTruffleCompilerListener listener = listenerHsHandle == null ? null : new HSTruffleCompilerListener(listenerHsHandle);
        HSTruffleCompilable compilable = new HSTruffleCompilable(compilableHsHandle);
        try (CompilationContext hotSpotObjectConstantScope = HotSpotGraalServices.openLocalCompilationContext(compilable);){
            truffleCompiler.doCompile(task, compilable, listener);
        }
    }

    public static void shutdown(Object compiler) {
        ((HotSpotTruffleCompilerImpl)compiler).shutdown();
    }

    public static void installTruffleCallBoundaryMethod(Object compiler, long methodHandle) {
        HotSpotTruffleCompilerImpl truffleCompiler = (HotSpotTruffleCompilerImpl)compiler;
        truffleCompiler.installTruffleCallBoundaryMethod((ResolvedJavaMethod)HotSpotJVMCIRuntime.runtime().unhand(ResolvedJavaMethod.class, methodHandle), null);
    }

    public static void installTruffleReservedOopMethod(Object compiler, long methodHandle) {
        HotSpotTruffleCompilerImpl truffleCompiler = (HotSpotTruffleCompilerImpl)compiler;
        truffleCompiler.installTruffleReservedOopMethod((ResolvedJavaMethod)HotSpotJVMCIRuntime.runtime().unhand(ResolvedJavaMethod.class, methodHandle), null);
    }

    public static int pendingTransferToInterpreterOffset(Object compiler, Object compilableHsHandle) {
        HotSpotTruffleCompilerImpl truffleCompiler = (HotSpotTruffleCompilerImpl)compiler;
        HSTruffleCompilable compilable = new HSTruffleCompilable(compilableHsHandle);
        return truffleCompiler.pendingTransferToInterpreterOffset(compilable);
    }

    public static String getSuppliedString(Object stringSupplier) {
        return (String)((Supplier)stringSupplier).get();
    }

    public static int getNodeCount(Object graphInfo) {
        return ((TruffleCompilerListener.GraphInfo)graphInfo).getNodeCount();
    }

    public static String[] getNodeTypes(Object graphInfo, boolean simpleNames) {
        return ((TruffleCompilerListener.GraphInfo)graphInfo).getNodeTypes(simpleNames);
    }

    public static int getTargetCodeSize(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getTargetCodeSize();
    }

    public static int getTotalFrameSize(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getTotalFrameSize();
    }

    public static int getExceptionHandlersCount(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getExceptionHandlersCount();
    }

    public static int getInfopointsCount(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getInfopointsCount();
    }

    public static String[] getInfopoints(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getInfopoints();
    }

    public static int getMarksCount(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getMarksCount();
    }

    public static int getDataPatchesCount(Object compilationResultInfo) {
        return ((TruffleCompilerListener.CompilationResultInfo)compilationResultInfo).getDataPatchesCount();
    }

    public static Object[] listCompilerOptions() {
        TruffleCompilerOptionDescriptor[] options = TruffleCompilerOptions.listOptions();
        Object[] result = new Object[options.length];
        for (int i = 0; i < options.length; ++i) {
            TruffleCompilerOptionDescriptor option = options[i];
            result[i] = NativeImageHostCalls.createTruffleCompilerOptionDescriptor(option.name(), option.type().ordinal(), option.deprecated(), option.help(), option.deprecationMessage());
        }
        return result;
    }

    public static boolean compilerOptionExists(String optionName) {
        return TruffleCompilerOptions.optionExists(optionName);
    }

    public static String validateCompilerOption(String optionName, String optionValue) {
        return TruffleCompilerOptions.validateOption(optionName, optionValue);
    }

    public static void purgePartialEvaluationCaches(Object compiler) {
        ((HotSpotTruffleCompilerImpl)compiler).purgePartialEvaluationCaches();
    }

    public static String getCompilerVersion() {
        return HSTruffleCompilerRuntime.COMPILER_VERSION;
    }

    public static long getCurrentJavaThread() {
        return HotSpotJVMCIRuntime.runtime().getCurrentJavaThread();
    }

    public static int getLastJavaPCOffset() {
        HotSpotVMConfigAccess configAccess = new HotSpotVMConfigAccess(HotSpotJVMCIRuntime.runtime().getConfigStore());
        int anchor = (Integer)configAccess.getFieldOffset("JavaThread::_anchor", Integer.class, "JavaFrameAnchor");
        int lastJavaPc = (Integer)configAccess.getFieldOffset("JavaFrameAnchor::_last_Java_pc", Integer.class, "address");
        return anchor + lastJavaPc;
    }
}

