/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal.truffle;

import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraal;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import jdk.graal.compiler.hotspot.libgraal.truffle.GraalEntryPoints;
import jdk.graal.compiler.hotspot.libgraal.truffle.LibGraalTruffleHostEnvironmentLookup;
import jdk.graal.compiler.hotspot.libgraal.truffle.NativeImageHostCalls;
import jdk.graal.compiler.truffle.host.TruffleHostEnvironment;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class BuildTime {
    private static MethodHandles.Lookup hostLookup;
    private static Class<?> truffleFromLibGraalStartPoint;
    private static Class<?> nativeImageHostEntryPoint;
    private static Map<String, MethodHandle> hostMethods;

    public static void configureGraalForLibGraal() {
        TruffleHostEnvironment.overrideLookup(new LibGraalTruffleHostEnvironmentLookup());
    }

    public static Map.Entry<MethodHandles.Lookup, Class<?>> initializeLookup(MethodHandles.Lookup lookup, Class<?> fromLibGraal, Class<?> nativeImageSupport) {
        if (hostLookup != null) {
            throw new IllegalStateException("Host lookup has already been initialized. BuildTime.initializeLookup should only be called once during the native image build process.");
        }
        hostLookup = Objects.requireNonNull(lookup, "lookup must be non null");
        truffleFromLibGraalStartPoint = Objects.requireNonNull(fromLibGraal, "fromLibGraal must be non null");
        nativeImageHostEntryPoint = Objects.requireNonNull(nativeImageSupport, "nativeImageSupport must be non null");
        return Map.entry(MethodHandles.lookup(), GraalEntryPoints.class);
    }

    static MethodHandle getHostMethodHandleOrFail(TruffleFromLibGraal.Id id) {
        return BuildTime.getHostMethodHandleOrFail(id.getMethodName());
    }

    static MethodHandle getHostMethodHandleOrFail(String name) {
        if (ImageInfo.inImageBuildtimeCode()) {
            MethodHandle handle;
            ClassLoader myLoader = BuildTime.class.getClassLoader();
            if (myLoader == null || myLoader == ClassLoader.getPlatformClassLoader() || myLoader == ClassLoader.getSystemClassLoader()) {
                return null;
            }
            if (hostMethods == null) {
                hostMethods = BuildTime.initializeHostMethods();
            }
            if ((handle = hostMethods.get(name)) != null) {
                return handle;
            }
            throw new NoSuchElementException(name);
        }
        if (ImageInfo.inImageRuntimeCode()) {
            throw new IllegalStateException("Should not be reachable at libgraal runtime");
        }
        return null;
    }

    private static Map<String, MethodHandle> initializeHostMethods() {
        try {
            String methodName;
            HashMap<String, MethodHandle> result = new HashMap<String, MethodHandle>();
            HashSet methodNames = new HashSet();
            Arrays.stream(TruffleFromLibGraal.Id.values()).map(TruffleFromLibGraal.Id::getMethodName).forEach(methodNames::add);
            for (Method m : truffleFromLibGraalStartPoint.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || !methodNames.remove(methodName = m.getName())) continue;
                result.put(methodName, hostLookup.unreflect(m));
            }
            if (!methodNames.isEmpty()) {
                throw new RuntimeException(String.format("Cannot find methods for following ids %s in %s", methodNames, truffleFromLibGraalStartPoint.getName()));
            }
            Arrays.stream(NativeImageHostCalls.class.getDeclaredMethods()).map(Method::getName).forEach(methodNames::add);
            for (Method m : nativeImageHostEntryPoint.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || !methodNames.remove(methodName = m.getName()) || result.put(methodName, hostLookup.unreflect(m)) == null) continue;
                throw new RuntimeException(String.format("Duplicate methods for name %s in %s", methodName, nativeImageHostEntryPoint));
            }
            if (!methodNames.isEmpty()) {
                throw new RuntimeException(String.format("Cannot find following methods %s in %s", methodNames, nativeImageHostEntryPoint));
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

