/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal;

import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.GlobalMetrics;
import jdk.graal.compiler.hotspot.CompilationContext;
import jdk.graal.compiler.hotspot.CompilationTask;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.ProfileReplaySupport;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import jdk.graal.compiler.util.OptionsEncoder;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.runtime.JVMCIBackend;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class RunTime {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final ThreadLocal<CachedOptions> CACHED_OPTIONS_THREAD_LOCAL = new ThreadLocal();
    private static long jniEnvironmentOffset = Integer.MAX_VALUE;

    private static OptionValues decodeOptions(long address, int size, int hash) {
        CachedOptions options = CACHED_OPTIONS_THREAD_LOCAL.get();
        if (options == null || options.hash != (long)hash) {
            byte[] buffer = new byte[size];
            UNSAFE.copyMemory(null, address, buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, size);
            int actualHash = Arrays.hashCode(buffer);
            if (actualHash != hash) {
                throw new IllegalArgumentException(actualHash + " != " + hash);
            }
            Map<String, Object> srcMap = OptionsEncoder.decode(buffer);
            EconomicMap<OptionKey<?>, Object> dstMap = OptionValues.newOptionMap();
            Iterable<OptionDescriptors> loader = OptionsParser.getOptionsLoader();
            for (Map.Entry<String, Object> e : srcMap.entrySet()) {
                String optionName = e.getKey();
                Object optionValue = e.getValue();
                OptionsParser.parseOption(optionName, optionValue, dstMap, loader);
            }
            options = new CachedOptions(new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)dstMap), hash);
            CACHED_OPTIONS_THREAD_LOCAL.set(options);
        }
        return options.options;
    }

    public static long compileMethod(long methodHandle, boolean useProfilingInfo, boolean installAsDefault, boolean printMetrics, boolean eagerResolving, long optionsAddress, int optionsSize, int optionsHash, String profileLoadPath, BiConsumer<Long, Long> timeAndMemConsumer, Supplier<Long> currentThreadAllocatedBytes) {
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)runtime.getCompiler();
        if (methodHandle == 0L) {
            return 0L;
        }
        int entryBCI = -1;
        HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)runtime.unhand(HotSpotResolvedJavaMethod.class, methodHandle);
        HotSpotCompilationRequest request = new HotSpotCompilationRequest(method, entryBCI, 0L);
        try (CompilationContext ignored = HotSpotGraalServices.openLocalCompilationContext(request);){
            CompilationTask task = new CompilationTask(runtime, compiler, request, useProfilingInfo, false, false, eagerResolving, installAsDefault);
            long allocatedBytesBefore = 0L;
            long timeBefore = 0L;
            if (timeAndMemConsumer != null) {
                allocatedBytesBefore = currentThreadAllocatedBytes.get();
                timeBefore = System.nanoTime();
            }
            OptionValues options = RunTime.decodeOptions(optionsAddress, optionsSize, optionsHash);
            if (profileLoadPath != null) {
                options = new OptionValues(options, ProfileReplaySupport.Options.LoadProfiles, profileLoadPath, new Object[0]);
            }
            task.runCompilation(options);
            if (timeAndMemConsumer != null) {
                long allocatedBytesAfter = currentThreadAllocatedBytes.get();
                long bytesAllocated = allocatedBytesAfter - allocatedBytesBefore;
                long timeAfter = System.nanoTime();
                long timeSpent = timeAfter - timeBefore;
                timeAndMemConsumer.accept(timeSpent, bytesAllocated);
            }
            HotSpotInstalledCode installedCode = task.getInstalledCode();
            if (printMetrics) {
                GlobalMetrics metricValues = ((HotSpotGraalRuntime)compiler.getGraalRuntime()).getMetricValues();
                metricValues.print(options);
                metricValues.clear();
            }
            long l = runtime.translate((Object)installedCode);
            return l;
        }
    }

    public static long hashConstantOopFields(long typeHandle, boolean useScope, int iterations, int oopsPerIteration, boolean verbose, Runnable doReferenceHandling) {
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        JVMCIBackend backend = runtime.getHostJVMCIBackend();
        ConstantReflectionProvider constantReflection = backend.getConstantReflection();
        HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)runtime.unhand(HotSpotResolvedJavaType.class, typeHandle);
        ResolvedJavaField[] staticFields = type.getStaticFields();
        JavaConstant receiver = null;
        long hash = 13L;
        String scopeDescription = "TestingOopHandles";
        int remainingIterations = iterations;
        while (remainingIterations-- > 0) {
            ResolvedJavaField lastReadField = null;
            try (CompilationContext scope = useScope ? HotSpotGraalServices.openLocalCompilationContext(scopeDescription) : null;){
                if (verbose && useScope) {
                    System.out.println("Opened " + String.valueOf(scopeDescription));
                }
                int remainingOops = oopsPerIteration;
                while (remainingOops-- > 0) {
                    for (ResolvedJavaField field : staticFields) {
                        JavaConstant value;
                        if (field.getType().getJavaKind() != JavaKind.Object || (value = constantReflection.readFieldValue(field, receiver)) == null) continue;
                        lastReadField = field;
                        hash ^= (long)value.hashCode();
                    }
                }
            }
            if (!useScope) {
                System.gc();
                if (verbose) {
                    System.out.println("calling reference handling");
                }
                doReferenceHandling.run();
                if (verbose) {
                    System.out.println("called reference handling");
                }
                constantReflection.readFieldValue(lastReadField, receiver);
                continue;
            }
            if (!verbose) continue;
            System.out.println(" Closed " + String.valueOf(scopeDescription));
        }
        return hash;
    }

    private static long getJniEnvironmentOffset() {
        if (jniEnvironmentOffset == Integer.MAX_VALUE) {
            HotSpotJVMCIRuntime jvmciRuntime = HotSpotJVMCIRuntime.runtime();
            HotSpotVMConfigStore store = jvmciRuntime.getConfigStore();
            HotSpotVMConfigAccess config = new HotSpotVMConfigAccess(store);
            jniEnvironmentOffset = ((Integer)config.getFieldOffset("JavaThread::_jni_environment", Integer.class, "JNIEnv")).intValue();
        }
        return jniEnvironmentOffset;
    }

    static long getJNIEnv() {
        HotSpotJVMCIRuntime jvmciRuntime = HotSpotJVMCIRuntime.runtime();
        long offset = RunTime.getJniEnvironmentOffset();
        long javaThreadAddr = jvmciRuntime.getCurrentJavaThread();
        return javaThreadAddr + offset;
    }

    public static boolean attachCurrentThread(boolean isDaemon, long[] isolate) {
        long[] javaVMInfo = isolate != null ? new long[4] : null;
        boolean res = HotSpotJVMCIRuntime.runtime().attachCurrentThread(isDaemon, javaVMInfo);
        if (isolate != null) {
            isolate[0] = javaVMInfo[1];
        }
        return res;
    }

    public static boolean detachCurrentThread(boolean release) {
        return HotSpotJVMCIRuntime.runtime().detachCurrentThread(release);
    }

    private record CachedOptions(OptionValues options, long hash) {
    }
}

