/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal;

import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.EncodedSnippets;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotReplacementsImpl;
import jdk.graal.compiler.hotspot.SymbolicSnippetEncoder;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleCompilerImpl;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class CompilerConfig {
    public static void main(String[] args) throws Exception {
        HotSpotGraalCompiler graalCompiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
        HotSpotGraalRuntimeProvider graalRuntime = graalCompiler.getGraalRuntime();
        HotSpotProviders hostProviders = graalRuntime.getHostProviders();
        HotSpotReplacementsImpl replacements = (HotSpotReplacementsImpl)hostProviders.getReplacements();
        OptionValues options = graalRuntime.getCapability(OptionValues.class);
        List<ForeignCallSignature> foreignCallSignatures = CompilerConfig.getForeignCallSignatures(replacements, options, graalRuntime);
        EncodedSnippets encodedSnippets = CompilerConfig.getEncodedSnippets(replacements, options);
        List<Field> externalValueFields = ObjectCopier.getExternalValueFields();
        EconomicMap encodedObjects = EconomicMap.create();
        encodedObjects.put((Object)"encodedSnippets", (Object)encodedSnippets);
        encodedObjects.put((Object)"foreignCallSignatures", foreignCallSignatures);
        ObjectCopier.Encoder encoder = new ObjectCopier.Encoder((List)externalValueFields){

            @Override
            protected ObjectCopier.ClassInfo makeClassInfo(Class<?> declaringClass) {
                ObjectCopier.ClassInfo ci = ObjectCopier.ClassInfo.of(declaringClass);
                for (Field f : ci.fields().values()) {
                    GraalError.guarantee(!f.getName().toLowerCase(Locale.ROOT).contains("hash"), "Cannot serialize hash field: %s", (Object)f);
                }
                return ci;
            }
        };
        byte[] encoded = ObjectCopier.encode(encoder, encodedObjects);
        Files.write(Path.of(args[0], new String[0]), encoded, new OpenOption[0]);
    }

    private static EncodedSnippets getEncodedSnippets(HotSpotReplacementsImpl replacements, OptionValues options) {
        SymbolicSnippetEncoder snippetEncoder = replacements.maybeInitializeEncoder();
        return snippetEncoder.encodeSnippets(options);
    }

    private static List<ForeignCallSignature> getForeignCallSignatures(HotSpotReplacementsImpl replacements, OptionValues options, HotSpotGraalRuntimeProvider graalRuntime) {
        ArrayList<ForeignCallSignature> sigs = new ArrayList<ForeignCallSignature>();
        EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage> foreignCalls = CompilerConfig.collectForeignCalls(replacements, options);
        MapCursor cursor = foreignCalls.getEntries();
        while (cursor.advance()) {
            ForeignCallSignature sig = (ForeignCallSignature)cursor.getKey();
            HotSpotForeignCallLinkage linkage = (HotSpotForeignCallLinkage)cursor.getValue();
            sigs.add(sig);
            if (linkage == null) continue;
            linkage.finalizeAddress(graalRuntime.getHostBackend());
        }
        return sigs;
    }

    private static EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage> collectForeignCalls(HotSpotReplacementsImpl replacements, OptionValues options) {
        EconomicMap allForeignCalls = EconomicMap.create();
        HotSpotProviders providers = replacements.getProviders();
        CompilerConfig.collectForeignCalls(providers.getForeignCalls(), (EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage>)allForeignCalls);
        for (Backend backend : HotSpotTruffleCompilerImpl.ensureBackendsInitialized(options)) {
            HotSpotProviders truffleProviders = (HotSpotProviders)backend.getProviders();
            CompilerConfig.collectForeignCalls(truffleProviders.getForeignCalls(), (EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage>)allForeignCalls);
        }
        return allForeignCalls;
    }

    private static void collectForeignCalls(HotSpotHostForeignCallsProvider foreignCalls, EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage> allForeignCalls) {
        foreignCalls.forEachForeignCall((sig, linkage) -> {
            if ((linkage == null || linkage.isCompiledStub()) && !allForeignCalls.containsKey(sig)) {
                allForeignCalls.put(sig, linkage);
            }
        });
    }
}

