/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.libgraal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.graal.compiler.core.ArchitectureSpecific;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.CompilerConfigurationFactory;
import jdk.graal.compiler.hotspot.EncodedSnippets;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotReplacementsImpl;
import jdk.graal.compiler.hotspot.libgraal.RunTime;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionsParser;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.services.JVMCIServiceLocator;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class BuildTime {
    private static final String VALID_LOADER_NAME = "LibGraalClassLoader";
    private static final ClassLoader LOADER = BuildTime.class.getClassLoader();
    private static final MethodHandles.Lookup MHL = MethodHandles.lookup();

    public static Object initLibgraalOptions() {
        return OptionsParser.setLibgraalOptions(OptionsParser.LibGraalOptionsInfo.create());
    }

    public static Iterable<?> finalizeLibgraalOptions(List<Object> optionObjects, Object optionsInfoObject, Map<String, String> modules) {
        GraalError.guarantee(VALID_LOADER_NAME.equals(LOADER.getName()), "Only call this method from classloader LibGraalClassLoader");
        OptionsParser.LibGraalOptionsInfo optionsInfo = (OptionsParser.LibGraalOptionsInfo)optionsInfoObject;
        for (Object optionObject : optionObjects) {
            OptionKey option = (OptionKey)optionObject;
            OptionDescriptor descriptor = option.getDescriptor();
            if (!descriptor.isServiceLoaded()) continue;
            String name = option.getName();
            optionsInfo.descriptors().put((Object)name, (Object)descriptor);
            String module = modules.get(descriptor.getDeclaringClass().getName());
            if (!module.contains("enterprise")) continue;
            optionsInfo.enterpriseOptions().add(name);
        }
        return optionsInfo.descriptors().getValues();
    }

    public static long[] getInputEdgesOffsets(Object rawNodeClass) {
        NodeClass nodeclass = (NodeClass)rawNodeClass;
        return nodeclass.getInputEdges().getOffsets();
    }

    public static long[] getSuccessorEdgesOffsets(Object rawNodeClass) {
        NodeClass nodeclass = (NodeClass)rawNodeClass;
        return nodeclass.getSuccessorEdges().getOffsets();
    }

    private static void addProviders(Map<Class<?>, List<?>> services, String arch, Class<?> service) {
        List providers = services.computeIfAbsent(service, key -> new ArrayList());
        for (Object provider : ServiceLoader.load(service, LOADER)) {
            ArchitectureSpecific as;
            if (provider instanceof ArchitectureSpecific && !(as = (ArchitectureSpecific)provider).getArchitecture().equals(arch)) continue;
            providers.add(provider);
        }
    }

    public static void configureGraalForLibGraal(String arch, List<Class<?>> guestServiceClasses, Consumer<Class<?>> registerAsInHeap, Consumer<List<Class<?>>> hostedGraalSetFoldNodePluginClasses, String nativeImageLocationQualifier, byte[] encodedGuestObjects) {
        GraalError.guarantee(VALID_LOADER_NAME.equals(LOADER.getName()), "Only call this method from classloader LibGraalClassLoader");
        HashMap services = new HashMap();
        guestServiceClasses.forEach(c -> BuildTime.addProviders(services, arch, c));
        GraalServices.setLibgraalServices(services);
        CompilerConfigurationFactory.setNativeImageLocationQualifier(nativeImageLocationQualifier);
        try {
            Field cachedHotSpotJVMCIBackendFactoriesField = ObjectCopier.getField(HotSpotJVMCIRuntime.class, "cachedHotSpotJVMCIBackendFactories");
            GraalError.guarantee(cachedHotSpotJVMCIBackendFactoriesField.get(null) == null, "Expect cachedHotSpotJVMCIBackendFactories to be null");
            ServiceLoader<HotSpotJVMCIBackendFactory> load = ServiceLoader.load(HotSpotJVMCIBackendFactory.class, LOADER);
            List<HotSpotJVMCIBackendFactory> backendFactories = load.stream().map(ServiceLoader.Provider::get).filter(s -> s.getArchitecture().equals(arch)).toList();
            cachedHotSpotJVMCIBackendFactoriesField.set(null, backendFactories);
            GraalError.guarantee(backendFactories.size() == 1, "%s", backendFactories);
            Field jvmciServiceLocatorCachedLocatorsField = ObjectCopier.getField(JVMCIServiceLocator.class, "cachedLocators");
            GraalError.guarantee(jvmciServiceLocatorCachedLocatorsField.get(null) == null, "Expect cachedLocators to be null");
            ServiceLoader<JVMCIServiceLocator> serviceLocators = ServiceLoader.load(JVMCIServiceLocator.class, LOADER);
            ArrayList cachedLocators = new ArrayList();
            serviceLocators.forEach(cachedLocators::add);
            jvmciServiceLocatorCachedLocatorsField.set(null, cachedLocators);
            EconomicMap libgraalObjects = (EconomicMap)ObjectCopier.decode(encodedGuestObjects, LOADER);
            EncodedSnippets encodedSnippets = (EncodedSnippets)libgraalObjects.get((Object)"encodedSnippets");
            for (NodeClass<?> nodeClass : encodedSnippets.getSnippetNodeClasses()) {
                registerAsInHeap.accept(nodeClass.getClazz());
            }
            HotSpotReplacementsImpl.setEncodedSnippets(encodedSnippets);
            List foreignCallSignatures = (List)libgraalObjects.get((Object)"foreignCallSignatures");
            HotSpotForeignCallLinkage.Stubs.initStubs(foreignCallSignatures);
            hostedGraalSetFoldNodePluginClasses.accept(GeneratedInvocationPlugin.getFoldNodePluginClasses());
        }
        catch (ReflectiveOperationException e) {
            throw GraalError.shouldNotReachHere(e);
        }
    }

    public static Map<String, MethodHandle> getRuntimeHandles() {
        try {
            return Map.of("compileMethod", MHL.findStatic(RunTime.class, "compileMethod", MethodType.methodType(Long.TYPE, Long.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, String.class, BiConsumer.class, Supplier.class)), "hashConstantOopFields", MHL.findStatic(RunTime.class, "hashConstantOopFields", MethodType.methodType(Long.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Runnable.class)), "getJNIEnv", MHL.findStatic(RunTime.class, "getJNIEnv", MethodType.methodType(Long.TYPE)), "attachCurrentThread", MHL.findStatic(RunTime.class, "attachCurrentThread", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, long[].class)), "detachCurrentThread", MHL.findStatic(RunTime.class, "detachCurrentThread", MethodType.methodType(Boolean.TYPE, Boolean.TYPE)), "getSavedProperty", MHL.findStatic(GraalServices.class, "getSavedProperty", MethodType.methodType(String.class, String.class)), "ttyPrintf", MHL.findStatic(TTY.class, "printf", MethodType.methodType(Void.TYPE, String.class, Object[].class)));
        }
        catch (Throwable e) {
            throw GraalError.shouldNotReachHere(e);
        }
    }
}

