/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64.z;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.ZWriteBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.hotspot.amd64.z.AMD64HotSpotZBarrierSetLIRGenerator;
import jdk.graal.compiler.hotspot.amd64.z.AMD64HotSpotZStoreBarrieredOp;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="CAS_Z")
public final class AMD64HotSpotZCompareAndSwapOp
extends AMD64HotSpotZStoreBarrieredOp {
    public static final LIRInstructionClass<AMD64HotSpotZCompareAndSwapOp> TYPE = LIRInstructionClass.create(AMD64HotSpotZCompareAndSwapOp.class);
    private final boolean isLogic;
    private final AMD64Kind accessKind;
    @LIRInstruction.Use
    protected AllocatableValue cmpValue;
    @LIRInstruction.Alive
    protected AllocatableValue newValue;

    public AMD64HotSpotZCompareAndSwapOp(boolean isLogic, AMD64Kind accessKind, AllocatableValue result, AMD64AddressValue address, AllocatableValue cmpValue, AllocatableValue newValue, AllocatableValue tmp, AllocatableValue tmp2, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget) {
        super(TYPE, result, address, tmp, tmp2, config, callTarget, ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic);
        this.isLogic = isLogic;
        this.accessKind = accessKind;
        this.cmpValue = cmpValue;
        this.newValue = newValue;
        assert (ValueUtil.asRegister((Value)cmpValue).equals((Object)AMD64.rax)) : cmpValue;
        assert (ValueUtil.asRegister((Value)result).equals((Object)AMD64.rax)) : result;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        GraalError.guarantee(this.accessKind == AMD64Kind.QWORD, "ZGC only supports uncompressed oops");
        assert (LIRValueUtil.differentRegisters(new Object[]{this.cmpValue, this.newValue, this.storeAddress}));
        this.emitPreWriteBarrier(crb, masm, ValueUtil.asRegister((Value)this.tmp), null);
        AMD64HotSpotZBarrierSetLIRGenerator.zColor(crb, masm, ValueUtil.asRegister((Value)this.tmp), ValueUtil.asRegister((Value)this.newValue));
        AMD64HotSpotZBarrierSetLIRGenerator.zColor(crb, masm, ValueUtil.asRegister((Value)this.cmpValue));
        if (crb.target.isMP) {
            masm.lock();
        }
        masm.cmpxchgq(ValueUtil.asRegister((Value)this.tmp), this.storeAddress.toAddress(masm));
        if (!this.isLogic) {
            Register ref = ValueUtil.asRegister((Value)this.cmpValue);
            AMD64HotSpotZBarrierSetLIRGenerator.zUncolor(crb, masm, ref);
        }
    }
}

