/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64.z;

import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.amd64.AMD64LIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64ReadBarrierSetLIRGenerator;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.hotspot.ZWriteBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.hotspot.amd64.z.AMD64HotSpotZAtomicReadAndWriteOp;
import jdk.graal.compiler.hotspot.amd64.z.AMD64HotSpotZCompareAndSwapOp;
import jdk.graal.compiler.hotspot.amd64.z.AMD64HotSpotZPreWriteBarrierOp;
import jdk.graal.compiler.hotspot.amd64.z.AMD64HotSpotZReadBarrierOp;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64BinaryConsumer;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.word.LocationIdentity;

public class AMD64HotSpotZBarrierSetLIRGenerator
implements AMD64ReadBarrierSetLIRGenerator,
ZWriteBarrierSetLIRGeneratorTool {
    private final GraalHotSpotVMConfig config;
    private final Providers providers;

    public AMD64HotSpotZBarrierSetLIRGenerator(GraalHotSpotVMConfig config, Providers providers) {
        this.config = config;
        this.providers = providers;
    }

    @Override
    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/x86/gc/z/z_x86_64.ad#L37-L42", sha1="344c51c07478c916bdaabb0c697a053e7a2f64dd")
    public static void zColor(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register ref) {
        crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_LOAD_GOOD_BEFORE_SHL);
        masm.shlq(ref, 0);
        masm.orqImm32(ref, 0);
        crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_GOOD_AFTER_OR);
    }

    public static void zColor(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register resultReg, Register writeValue) {
        Assembler.guaranteeDifferentRegisters(writeValue, resultReg);
        masm.movq(resultReg, writeValue);
        AMD64HotSpotZBarrierSetLIRGenerator.zColor(crb, masm, resultReg);
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/x86/gc/z/z_x86_64.ad#L44-L47", sha1="5024a425db7a0d1504713ad9029a68da6089967f")
    public static void zUncolor(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register ref) {
        crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_LOAD_GOOD_BEFORE_SHL);
        masm.shrq(ref, 0);
    }

    @SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/x86/gc/z/zBarrierSetAssembler_x86.cpp#L304-L321", sha1="9a628c1771df79ae8b4cee89d2863fbd4a4964bc"), @SyncPort(from="https://github.com/openjdk/jdk/blob/d8430efb5e159b8e08d2cac66b46cb4ff1112927/src/hotspot/cpu/x86/gc/z/zBarrierSetAssembler_x86.cpp#L374-L418", sha1="7688e7aeab5f1aa413690066355a17c18a4273fa")})
    public static void emitPreWriteBarrier(CompilationResultBuilder crb, AMD64MacroAssembler masm, LIRInstruction op, GraalHotSpotVMConfig config, AMD64Address address, Register result, ZWriteBarrierSetLIRGeneratorTool.StoreKind storeKind, Register tmp, Register tmp2, ForeignCallLinkage callTarget, LIRFrameState state) {
        Label mediumPath = new Label();
        Label mediumPathContinuation = new Label();
        Assembler.guaranteeDifferentRegisters(result, address.getBase(), address.getIndex());
        if (storeKind == ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic) {
            if (state != null) {
                crb.recordImplicitException(masm.position(), state);
            }
            masm.cmpwImm16(address, 0);
            crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_GOOD_AFTER_CMP);
        } else {
            if (state != null) {
                crb.recordImplicitException(masm.position(), state);
            }
            masm.testl(address, 0);
            crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_BAD_AFTER_TEST);
        }
        masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, mediumPath);
        masm.bind(mediumPathContinuation);
        crb.getLIR().addSlowPath(op, () -> {
            masm.bind(mediumPath);
            Label slow = new Label();
            Label slowContinuation = new Label();
            AMD64HotSpotZBarrierSetLIRGenerator.storeBarrierMedium(crb, masm, address, tmp, tmp2, storeKind, mediumPathContinuation, slow, slowContinuation, config);
            masm.bind(slow);
            masm.leaq(tmp, address);
            CallingConvention cc = callTarget.getOutgoingCallingConvention();
            AMD64Address cArg0 = (AMD64Address)crb.asAddress((Value)cc.getArgument(0));
            masm.movq(cArg0, tmp);
            AMD64Call.directCall(crb, masm, callTarget, null, false, null);
            assert (cc.getReturn().equals((Object)Value.ILLEGAL)) : String.valueOf(cc) + " " + String.valueOf(callTarget);
            masm.jmp(slowContinuation);
        });
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/d8430efb5e159b8e08d2cac66b46cb4ff1112927/src/hotspot/cpu/x86/gc/z/zBarrierSetAssembler_x86.cpp#L454-L509", sha1="4b729acf92e6a297229b7f1e957601708c315f4f")
    static void storeBarrierMedium(CompilationResultBuilder crb, AMD64MacroAssembler masm, AMD64Address address, Register tmp, Register tmp2, ZWriteBarrierSetLIRGeneratorTool.StoreKind storeKind, Label mediumPathContinuation, Label slowPath, Label slowPathContinuation, GraalHotSpotVMConfig config) {
        if (storeKind == ZWriteBarrierSetLIRGeneratorTool.StoreKind.Native) {
            masm.jmp(slowPath);
            masm.bind(slowPathContinuation);
            masm.jmp(mediumPathContinuation);
        } else if (storeKind == ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic) {
            masm.cmpq(address, 0);
            masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, slowPath);
            masm.push(AMD64.rax);
            masm.push(AMD64.rbx);
            masm.push(AMD64.rcx);
            masm.leaq(AMD64.rcx, address);
            masm.xorq(AMD64.rax, AMD64.rax);
            masm.movptr(AMD64.rbx, new AMD64Address(AMD64.r15, config.ZThreadLocalData_store_good_mask_offset));
            masm.lock();
            masm.cmpxchgq(AMD64.rbx, new AMD64Address(AMD64.rcx, 0));
            masm.pop(AMD64.rcx);
            masm.pop(AMD64.rbx);
            masm.pop(AMD64.rax);
            masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, slowPath);
            masm.bind(slowPathContinuation);
            masm.jmp(mediumPathContinuation);
        } else {
            if (GraalOptions.AssemblyGCBarriersSlowPathOnly.getValue(crb.getOptions()).booleanValue()) {
                masm.jmp(slowPath);
            } else {
                AMD64HotSpotZBarrierSetLIRGenerator.storeBarrierBufferAdd(masm, address, tmp, tmp2, slowPath, config);
            }
            masm.bind(slowPathContinuation);
            masm.jmp(mediumPathContinuation);
        }
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/d8430efb5e159b8e08d2cac66b46cb4ff1112927/src/hotspot/cpu/x86/gc/z/zBarrierSetAssembler_x86.cpp#L420-L452", sha1="638b10c65bb14fa4b254efa4d5bbb1751fdbb6bf")
    static void storeBarrierBufferAdd(AMD64MacroAssembler masm, AMD64Address address, Register tmp1, Register tmp2, Label slowPath, GraalHotSpotVMConfig config) {
        AMD64Address buffer = new AMD64Address(AMD64.r15, config.ZThreadLocalData_store_barrier_buffer_offset);
        masm.movptr(tmp1, buffer);
        masm.cmpq(new AMD64Address(tmp1, config.ZStoreBarrierBuffer_current_offset), 0);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, slowPath);
        masm.movq(tmp2, new AMD64Address(tmp1, config.ZStoreBarrierBuffer_current_offset));
        masm.subq(tmp2, config.sizeofZStoreBarrierEntry);
        masm.movq(new AMD64Address(tmp1, config.ZStoreBarrierBuffer_current_offset), tmp2);
        masm.leaq(tmp2, new AMD64Address(tmp1, tmp2, Stride.S1, config.ZStoreBarrierBuffer_buffer_offset));
        masm.leaq(tmp1, address);
        masm.movptr(new AMD64Address(tmp2, config.ZStoreBarrierEntry_p_offset), tmp1);
        masm.movptr(tmp1, new AMD64Address(tmp1, 0));
        masm.movptr(new AMD64Address(tmp2, config.ZStoreBarrierEntry_prev_offset), tmp1);
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/4acafb809c66589fbbfee9c9a4ba7820f848f0e4/src/hotspot/cpu/x86/gc/z/zBarrierSetAssembler_x86.cpp#L219-L302", sha1="16f5bff0a0f68ae40be8dd980b7728d7ee60cd2c")
    public static void emitLoadBarrier(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register resultReg, ForeignCallLinkage callTarget, AMD64Address address, LIRInstruction op, boolean isNotStrong) {
        assert (!resultReg.equals((Object)address.getBase()) && !resultReg.equals((Object)address.getIndex())) : Assertions.errorMessage(resultReg, address);
        Label entryPoint = new Label();
        Label continuation = new Label();
        if (isNotStrong) {
            masm.testl(resultReg, 0);
            crb.recordMark(HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_MARK_BAD_AFTER_TEST);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, entryPoint);
            AMD64HotSpotZBarrierSetLIRGenerator.zUncolor(crb, masm, resultReg);
        } else {
            AMD64HotSpotZBarrierSetLIRGenerator.zUncolor(crb, masm, resultReg);
            masm.jcc(AMD64Assembler.ConditionFlag.Above, entryPoint);
        }
        crb.getLIR().addSlowPath(op, () -> {
            masm.bind(entryPoint);
            CallingConvention cc = callTarget.getOutgoingCallingConvention();
            AMD64Address cArg0 = (AMD64Address)crb.asAddress((Value)cc.getArgument(0));
            AMD64Address cArg1 = (AMD64Address)crb.asAddress((Value)cc.getArgument(1));
            masm.movq(resultReg, address);
            masm.movq(cArg0, resultReg);
            masm.leaq(resultReg, address);
            masm.movq(cArg1, resultReg);
            AMD64Call.directCall(crb, masm, callTarget, null, false, null);
            masm.movq(resultReg, cArg0);
            masm.jmp(continuation);
        });
        masm.bind(continuation);
    }

    @Override
    public Variable emitBarrieredLoad(LIRGeneratorTool tool, LIRKind kind, Value address, LIRFrameState state, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        if (kind.getPlatformKind().getVectorLength() == 1) {
            GraalError.guarantee(kind.getPlatformKind() == AMD64Kind.QWORD, "ZGC only uses uncompressed oops: %s", (Object)kind);
            ForeignCallLinkage callTarget = this.getReadBarrierStub(barrierType);
            AMD64AddressValue loadAddress = ((AMD64LIRGenerator)tool).asAddressValue(address);
            Variable result = tool.newVariable(tool.toRegisterKind(kind));
            tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
            boolean isNotStrong = barrierType == BarrierType.REFERENCE_GET || barrierType == BarrierType.WEAK_REFERS_TO || barrierType == BarrierType.PHANTOM_REFERS_TO;
            tool.append(new AMD64HotSpotZReadBarrierOp(result, loadAddress, state, this.config, callTarget, isNotStrong));
            return result;
        }
        throw GraalError.shouldNotReachHere("unhandled barrier");
    }

    @Override
    public void emitCompareAndSwapOp(LIRGeneratorTool tool, boolean isLogic, LIRKind accessKind, AMD64Kind memKind, RegisterValue raxValue, AMD64AddressValue address, AllocatableValue newValue, BarrierType barrierType) {
        ForeignCallLinkage callTarget = this.getWriteBarrierStub(barrierType, ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic);
        assert (memKind == accessKind.getPlatformKind()) : Assertions.errorMessage(new Object[]{memKind, accessKind, raxValue, address, newValue});
        Variable tmp = tool.newVariable(tool.toRegisterKind(accessKind));
        Variable tmp2 = tool.newVariable(tool.toRegisterKind(accessKind));
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        tool.append(new AMD64HotSpotZCompareAndSwapOp(isLogic, memKind, (AllocatableValue)raxValue, address, (AllocatableValue)raxValue, tool.asAllocatable((Value)newValue), tmp, tmp2, this.config, callTarget));
    }

    @Override
    public Value emitAtomicReadAndWrite(LIRGeneratorTool tool, LIRKind accessKind, Value address, Value newValue, BarrierType barrierType) {
        AMD64Kind kind = (AMD64Kind)accessKind.getPlatformKind();
        GraalError.guarantee(barrierType == BarrierType.FIELD || barrierType == BarrierType.ARRAY, "unexpected type for barrier: %s", (Object)barrierType);
        Variable result = tool.newVariable(accessKind);
        AMD64AddressValue addressValue = ((AMD64LIRGenerator)tool).asAddressValue(address);
        Variable tmp = tool.newVariable(tool.toRegisterKind(accessKind));
        Variable tmp2 = tool.newVariable(tool.toRegisterKind(accessKind));
        GraalError.guarantee(kind == AMD64Kind.QWORD, "unexpected kind for ZGC");
        ForeignCallLinkage callTarget = this.getWriteBarrierStub(barrierType, ZWriteBarrierSetLIRGeneratorTool.StoreKind.Atomic);
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        tool.append(new AMD64HotSpotZAtomicReadAndWriteOp(result, addressValue, tool.asAllocatable(newValue), tmp, tmp2, this.config, callTarget));
        return result;
    }

    @Override
    public void emitStore(LIRGeneratorTool lirTool, ValueKind<?> lirKind, BarrierType barrierType, Value address, Value value, LIRFrameState state, MemoryOrderMode memoryOrder, LocationIdentity location) {
        AMD64LIRGenerator tool = (AMD64LIRGenerator)lirTool;
        AMD64AddressValue storeAddress = tool.asAddressValue(address);
        AMD64Kind kind = (AMD64Kind)lirKind.getPlatformKind();
        GraalError.guarantee(kind == AMD64Kind.QWORD, "unexpected kind for ZGC");
        boolean isConstantNull = LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).isDefaultForKind();
        LIRFrameState nullCheckState = state;
        Object writeValue = value;
        if (!location.isInit() || !isConstantNull) {
            ZWriteBarrierSetLIRGeneratorTool.StoreKind storeKind = location instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity ? ZWriteBarrierSetLIRGeneratorTool.StoreKind.Native : ZWriteBarrierSetLIRGeneratorTool.StoreKind.Normal;
            LIRKind accessKind = (LIRKind)value.getValueKind();
            Variable result = tool.newVariable(accessKind);
            AMD64AddressValue addressValue = tool.asAddressValue(address);
            Variable tmp = tool.newVariable(tool.toRegisterKind(accessKind));
            Variable tmp2 = tool.newVariable(tool.toRegisterKind(accessKind));
            ForeignCallLinkage callTarget = this.getWriteBarrierStub(barrierType, storeKind);
            tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
            boolean emitPreWriteBarrier = !location.isInit() || barrierType == BarrierType.POST_INIT_WRITE;
            tool.append(new AMD64HotSpotZPreWriteBarrierOp((Value)(isConstantNull ? Value.ILLEGAL : tool.asAllocatable(value)), addressValue, tmp, tmp2, this.config, callTarget, result, storeKind, emitPreWriteBarrier, emitPreWriteBarrier ? state : null));
            if (emitPreWriteBarrier) {
                nullCheckState = null;
            }
            writeValue = result;
        }
        if (isConstantNull) {
            tool.append(new ZStoreNullOp(AMD64BaseAssembler.OperandSize.QWORD, storeAddress, nullCheckState));
            if (memoryOrder == MemoryOrderMode.VOLATILE) {
                lirTool.emitMembar(4);
            }
        } else {
            tool.getArithmetic().emitStore(lirKind, address, (Value)writeValue, nullCheckState, memoryOrder);
        }
    }

    static class ZStoreNullOp
    extends AMD64BinaryConsumer.MemoryConstOp {
        public static final LIRInstructionClass<ZStoreNullOp> TYPE = LIRInstructionClass.create(ZStoreNullOp.class);

        ZStoreNullOp(AMD64BaseAssembler.OperandSize size, AMD64AddressValue x, LIRFrameState state) {
            super(TYPE, AMD64Assembler.AMD64MIOp.MOV, size, x, 0, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            super.emitCode(crb, masm);
            crb.recordMark(masm.position() - 1, HotSpotMarkId.Z_BARRIER_RELOCATION_FORMAT_STORE_GOOD_AFTER_MOV);
        }
    }
}

