/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.amd64.AMD64X87MathIntrinsicNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.word.LocationIdentity;

public class AMD64X87MathSnippets
implements Snippets {
    private static final double PI_4 = 0.7853981633974483;

    @Snippet
    public static double sin(double input) {
        if (BranchProbabilityNode.probability(0.6, Math.abs(input) < 0.7853981633974483)) {
            return AMD64X87MathIntrinsicNode.compute(input, UnaryMathIntrinsicNode.UnaryOperation.SIN);
        }
        return AMD64X87MathSnippets.callDouble1(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature, input);
    }

    @Snippet
    public static double cos(double input) {
        if (BranchProbabilityNode.probability(0.6, Math.abs(input) < 0.7853981633974483)) {
            return AMD64X87MathIntrinsicNode.compute(input, UnaryMathIntrinsicNode.UnaryOperation.COS);
        }
        return AMD64X87MathSnippets.callDouble1(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature, input);
    }

    @Snippet
    public static double tan(double input) {
        if (BranchProbabilityNode.probability(0.6, Math.abs(input) < 0.7853981633974483)) {
            return AMD64X87MathIntrinsicNode.compute(input, UnaryMathIntrinsicNode.UnaryOperation.TAN);
        }
        return AMD64X87MathSnippets.callDouble1(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature, input);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native double callDouble1(@Node.ConstantNodeParameter ForeignCallSignature var0, double var1);

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo sin;
        private final SnippetTemplate.SnippetInfo cos;
        private final SnippetTemplate.SnippetInfo tan;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.sin = this.snippet(providers, AMD64X87MathSnippets.class, "sin", new LocationIdentity[0]);
            this.cos = this.snippet(providers, AMD64X87MathSnippets.class, "cos", new LocationIdentity[0]);
            this.tan = this.snippet(providers, AMD64X87MathSnippets.class, "tan", new LocationIdentity[0]);
        }

        public void lower(UnaryMathIntrinsicNode mathIntrinsicNode, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(switch (mathIntrinsicNode.getOperation()) {
                case UnaryMathIntrinsicNode.UnaryOperation.SIN -> this.sin;
                case UnaryMathIntrinsicNode.UnaryOperation.COS -> this.cos;
                case UnaryMathIntrinsicNode.UnaryOperation.TAN -> this.tan;
                default -> throw GraalError.shouldNotReachHere("Snippet not found for math intrinsic " + mathIntrinsicNode.getOperation().name());
            }, mathIntrinsicNode.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("input", mathIntrinsicNode.getValue());
            this.template(tool, mathIntrinsicNode, args).instantiate(tool.getMetaAccess(), mathIntrinsicNode, SnippetTemplate.DEFAULT_REPLACER, tool, args);
            mathIntrinsicNode.safeDelete();
        }
    }
}

