/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMathIntrinsicOp;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

@NodeInfo(nameTemplate="X87MathIntrinsic#{p#operation/s}", cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_1)
public final class AMD64X87MathIntrinsicNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<AMD64X87MathIntrinsicNode> TYPE = NodeClass.create(AMD64X87MathIntrinsicNode.class);
    protected final UnaryMathIntrinsicNode.UnaryOperation operation;

    protected AMD64X87MathIntrinsicNode(ValueNode value, UnaryMathIntrinsicNode.UnaryOperation op) {
        super(TYPE, UnaryMathIntrinsicNode.UnaryOperation.computeStamp(op, value.stamp(NodeView.DEFAULT)), value);
        assert (value.stamp(NodeView.DEFAULT) instanceof FloatStamp && PrimitiveStamp.getBits(value.stamp(NodeView.DEFAULT)) == 64) : Assertions.errorMessage(value);
        this.operation = op;
    }

    @Override
    public Stamp foldStamp(Stamp valueStamp) {
        return UnaryMathIntrinsicNode.UnaryOperation.computeStamp(this.operation, valueStamp);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool gen = generator.getLIRGeneratorTool();
        Value input = generator.operand(this.getValue());
        Variable result = gen.newVariable(LIRKind.combine(input));
        VirtualStackSlot stack = gen.getResult().getFrameMapBuilder().allocateSpillSlot(LIRKind.value((PlatformKind)AMD64Kind.DOUBLE));
        switch (this.operation) {
            case SIN: 
            case COS: 
            case TAN: 
            case LOG: 
            case LOG10: {
                gen.append(new AMD64HotSpotMathIntrinsicOp(this.operation, (Value)result, (Value)gen.asAllocatable(input), (Value)stack));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.operation);
            }
        }
        generator.setResult(this, (Value)result);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            return ConstantNode.forDouble(UnaryMathIntrinsicNode.UnaryOperation.compute(this.operation, forValue.asJavaConstant().asDouble()));
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native double compute(double var0, @Node.ConstantNodeParameter UnaryMathIntrinsicNode.UnaryOperation var2);
}

